/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.generic.application;

import fr.emac.gind.application.model.GJaxbApplication;
import fr.emac.gind.generic.application.DWApplicationService;
import fr.emac.gind.gov.ai.chatbot.service.builder.ModelBuilderSelector;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveMetaModel;
import org.json.JSONObject;

public class ApplicationContext {
    protected GJaxbApplication application = null;
    protected GJaxbEffectiveMetaModel core = null;
    protected GJaxbEffectiveMetaModel project = null;
    protected GJaxbEffectiveMetaModel system = null;
    protected GJaxbEffectiveMetaModel uml = null;
    private String additional_logo = null;
    private String mainColor = null;
    protected DWApplicationService applicationService = null;
    private GJaxbNode currentUser = null;
    private JSONObject allWebApplications = new JSONObject();

    public ApplicationContext(DWApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    public GJaxbApplication getApplication() {
        return this.application;
    }

    public void setApplication(GJaxbApplication application) {
        this.application = application;
    }

    public JSONObject getAllWebApplications() {
        return this.allWebApplications;
    }

    public void setAllWebApplications(JSONObject allWebApplications) {
        this.allWebApplications = allWebApplications;
    }

    public GJaxbEffectiveMetaModel getCore() {
        return this.core;
    }

    public void setCore(GJaxbEffectiveMetaModel core) {
        this.core = core;
    }

    public GJaxbEffectiveMetaModel getProject() {
        return this.project;
    }

    public void setProject(GJaxbEffectiveMetaModel project) {
        this.project = project;
    }

    public GJaxbEffectiveMetaModel getSystem() {
        return this.system;
    }

    public void setSystem(GJaxbEffectiveMetaModel system) {
        this.system = system;
    }

    public GJaxbEffectiveMetaModel getUml() {
        return this.uml;
    }

    public void setUml(GJaxbEffectiveMetaModel uml) {
        this.uml = uml;
    }

    public GJaxbNode getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(GJaxbNode currentUser) {
        this.currentUser = currentUser;
    }

    public String getAdditional_logo() {
        return this.additional_logo;
    }

    public void setAdditional_logo(String additional_logo) {
        this.additional_logo = additional_logo;
    }

    public String getMainColor() {
        return this.mainColor;
    }

    public void setMainColor(String mainColor) {
        this.mainColor = mainColor;
    }

    public JSONObject toJSON() throws Exception {
        JSONObject json = new JSONObject();
        json.put("application", (Object)new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)this.application)));
        json.put("core", (Object)new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)this.core)));
        json.put("project", (Object)new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)this.project)));
        json.put("system", (Object)new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)this.system)));
        json.put("uml", (Object)new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)this.uml)));
        json.put("allWebApplications", (Object)this.allWebApplications);
        json.put("redirection", (Object)this.applicationService.getRedirection());
        json.put("version", this.applicationService.getConfiguration().getProperties().get("version"));
        json.put("proxy-port", this.applicationService.getConfiguration().getProperties().get("proxy-port"));
        json.put("generationDate", this.applicationService.getConfiguration().getProperties().get("generation-date"));
        json.put("tools_r-iopiot", this.applicationService.getConfiguration().getProperties().get("tools_r-iopiot"));
        if (this.currentUser != null) {
            json.put("currentUser", (Object)new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)this.currentUser)));
            this.currentUser = null;
        }
        if (this.mainColor != null) {
            json.put("additional_mainColor", (Object)this.mainColor);
        }
        if (this.additional_logo != null) {
            json.put("additional_logo", (Object)this.additional_logo);
        }
        if (System.getenv("OPENAI_CHATGPT_API_KEY") != null) {
            json.put("HAS_OPENAI_CHATGPT_API_KEY", true);
        }
        if (System.getenv("GOOGLE_API_KEY") != null) {
            json.put("GOOGLE_API_KEY", (Object)System.getenv("GOOGLE_API_KEY"));
        }
        if (System.getenv("UNSPLASH_ACCESS_KEY") != null) {
            json.put("UNSPLASH_ACCESS_KEY", (Object)System.getenv("UNSPLASH_ACCESS_KEY"));
        }
        if (System.getenv("FULLCALENDAR_LICENSE_KEY") != null) {
            json.put("FULLCALENDAR_LICENSE_KEY", (Object)System.getenv("FULLCALENDAR_LICENSE_KEY"));
        }
        if (System.getenv("MAPTILER_KEY") != null) {
            json.put("MAPTILER_KEY", (Object)System.getenv("MAPTILER_KEY"));
        }
        json.put("exisingChatModels", (Object)ModelBuilderSelector.getInstance().existingChatModels());
        json.put("exisingImageAnalysisChatModels", (Object)ModelBuilderSelector.getInstance().existingImageAnalysisChatModels());
        json.put("exisingImageCreationModels", (Object)ModelBuilderSelector.getInstance().existingImageCreationModels());
        return json;
    }
}

