/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.generic.application.auth;

import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.gov.system_gov.GJaxbFindUserByLoginAndPassword;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.rio.dw.resources.gov.SystemResource;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import io.dropwizard.auth.basic.BasicCredentials;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthenticator
implements Authenticator<BasicCredentials, DWUser> {
    private static Logger LOG = LoggerFactory.getLogger((String)BasicAuthenticator.class.getName());
    private SystemResource system = null;

    public BasicAuthenticator(SystemResource system) {
        this.system = system;
    }

    public Optional<DWUser> authenticate(BasicCredentials credentials) throws AuthenticationException {
        try {
            String login = credentials.getUsername();
            String password = credentials.getPassword();
            GJaxbFindUserByLoginAndPassword req = new GJaxbFindUserByLoginAndPassword();
            req.setLogin(login);
            req.setPassword(password);
            GJaxbNode user = this.system.getSystemClient().findUserByLoginAndPassword(req).getNode();
            if (user == null) {
                throw new AuthenticationException("Login and/or password are invalid !!!");
            }
            LOG.debug("Authentification successfully!!!");
            return Optional.of(new DWUser(user, this.system.getSystemClient()));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(e.getMessage(), (Throwable)e);
            if (!e.getClass().getName().equals(AuthenticationException.class.getName())) {
                throw new AuthenticationException(e.getMessage(), (Throwable)e);
            }
            throw (AuthenticationException)e;
        }
    }
}

