/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.generic.application.bundles;

import fr.emac.gind.generic.application.bundles.AbstractModifierResource;
import fr.emac.gind.generic.application.bundles.AssetInterceptorServlet;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.ConfiguredBundle;
import io.dropwizard.core.setup.Environment;
import jakarta.servlet.Servlet;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetsInterceptorBundle
implements ConfiguredBundle<Configuration> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AssetsInterceptorBundle.class);
    private static final String DEFAULT_ASSETS_NAME = "assets";
    private static final String DEFAULT_INDEX_FILE = "index.html";
    private static final String DEFAULT_PATH = "/assets";
    private static final String DEFAULT_MEDIA_TYPE = "text/html";
    private final String resourcePath;
    private final String uriPath;
    private final String indexFile;
    private final String assetsName;
    private final String defaultMediaType;
    private Map<String, AbstractModifierResource> mapModifiers = new HashMap<String, AbstractModifierResource>();

    public AssetsInterceptorBundle(AbstractModifierResource ... abstractModifierResources) {
        this(DEFAULT_PATH, DEFAULT_PATH, DEFAULT_INDEX_FILE, DEFAULT_ASSETS_NAME, DEFAULT_MEDIA_TYPE, abstractModifierResources);
    }

    public AssetsInterceptorBundle(String path, AbstractModifierResource ... abstractModifierResources) {
        this(path, path, DEFAULT_INDEX_FILE, DEFAULT_ASSETS_NAME, DEFAULT_MEDIA_TYPE, abstractModifierResources);
    }

    public AssetsInterceptorBundle(String resourcePath, String uriPath, AbstractModifierResource ... abstractModifierResources) {
        this(resourcePath, uriPath, DEFAULT_INDEX_FILE, DEFAULT_ASSETS_NAME, DEFAULT_MEDIA_TYPE, abstractModifierResources);
    }

    public AssetsInterceptorBundle(String resourcePath, String uriPath, String indexFile, AbstractModifierResource ... abstractModifierResources) {
        this(resourcePath, uriPath, indexFile, DEFAULT_ASSETS_NAME, DEFAULT_MEDIA_TYPE, abstractModifierResources);
    }

    public AssetsInterceptorBundle(String resourcePath, String uriPath, String indexFile, String assetsName, AbstractModifierResource ... abstractModifierResources) {
        this(resourcePath, uriPath, indexFile, assetsName, DEFAULT_MEDIA_TYPE, abstractModifierResources);
    }

    public AssetsInterceptorBundle(String resourcePath, String uriPath, String indexFile, String assetsName, String defaultMediaType, AbstractModifierResource ... abstractModifierResources) {
        if (!resourcePath.startsWith("/")) {
            throw new IllegalArgumentException(resourcePath + " is not an absolute path");
        }
        if ("/".equals(resourcePath)) {
            throw new IllegalArgumentException(resourcePath + " is the classpath root");
        }
        this.resourcePath = resourcePath.endsWith("/") ? resourcePath : resourcePath + "/";
        this.uriPath = uriPath.endsWith("/") ? uriPath : uriPath + "/";
        this.indexFile = indexFile;
        this.assetsName = assetsName;
        this.defaultMediaType = defaultMediaType;
        for (AbstractModifierResource modifier : abstractModifierResources) {
            this.addModifierResource(modifier);
        }
    }

    public void addModifierResource(AbstractModifierResource modifier) {
        this.mapModifiers.put(modifier.getClass().getName(), modifier);
    }

    public void run(Configuration configuration, Environment environment) {
        String pathPattern = this.uriPath + "*";
        LOGGER.info("Registering AssetBundle with name: {} for path {}", (Object)this.assetsName, (Object)pathPattern);
        environment.servlets().addServlet(this.assetsName, (Servlet)this.createServlet()).addMapping(new String[]{pathPattern});
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public String getUriPath() {
        return this.uriPath;
    }

    public String getIndexFile() {
        return this.indexFile;
    }

    public String getDefaultMediaType() {
        return this.defaultMediaType;
    }

    protected AssetInterceptorServlet createServlet() {
        return new AssetInterceptorServlet(this.resourcePath, this.uriPath, this.indexFile, this.defaultMediaType, StandardCharsets.UTF_8, this.mapModifiers);
    }
}

