/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources;

import fr.emac.gind.generic.application.GindWebApplicationException;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.storage.GJaxbQuery;
import fr.emac.gind.storage.GJaxbQueryResponse;
import fr.emac.gind.storage.GJaxbUpdate;
import fr.emac.gind.storage.GJaxbUpdateResponse;
import fr.emac.gind.storage.Storage;
import fr.emac.gind.storage.client.StorageClient;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;

@Path(value="/{app}/generic-application/storage")
public class StorageResource {
    private Configuration conf = null;
    private Storage storageClient = null;

    public StorageResource(Configuration configuration) throws Exception {
        this.conf = configuration;
        this.storageClient = StorageClient.createClient((String)this.conf.getMapObjects().get("storage").toString());
    }

    @POST
    @Path(value="/query")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbQueryResponse query(@Auth DWUser user, GJaxbQuery query) throws Exception {
        GJaxbQueryResponse responseQuery = null;
        try {
            responseQuery = this.storageClient.query(query);
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
        }
        return responseQuery;
    }

    @POST
    @Path(value="/update")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbUpdateResponse update(@Auth DWUser user, GJaxbUpdate updateReq) throws Exception {
        GJaxbUpdateResponse updateResp = null;
        try {
            updateResp = this.storageClient.update(updateReq);
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError(e, this);
        }
        return updateResp;
    }
}

