/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.generic.application.utils;

import fr.emac.gind.commons.utils.lang.reflect.ReflectionHelper;
import io.dropwizard.core.setup.Environment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RestResourceManager {
    private Environment env = null;
    private List<Object> resources = Collections.synchronizedList(new ArrayList());

    public RestResourceManager(Environment env) {
        this.env = env;
    }

    public <T> T findResource(Class<T> clazz) {
        for (Object resource : this.resources) {
            if (!resource.getClass().getName().equals(clazz.getName())) continue;
            return (T)resource;
        }
        return null;
    }

    public void addResource(Object resource, boolean force) {
        if (force) {
            this.resources.add(resource);
        } else {
            Object existingResource = this.containsEquivalentResource(resource);
            if (existingResource != null) {
                this.resources.remove(existingResource);
            }
            this.resources.add(resource);
        }
    }

    public void addResource(Object resource) {
        this.addResource(resource, false);
    }

    public void registerAllResources() {
        for (Object resource : this.resources) {
            this.env.jersey().register(resource);
        }
    }

    private Object containsEquivalentResource(Object resource) {
        ArrayList classes1 = new ArrayList();
        classes1.addAll(ReflectionHelper.findAllSuperClasses(resource.getClass()));
        classes1.add(resource.getClass());
        for (Object rsc : this.getResources()) {
            ArrayList classes2 = new ArrayList();
            classes2.addAll(ReflectionHelper.findAllSuperClasses(rsc.getClass()));
            classes2.add(rsc.getClass());
            for (Class clazz : classes1) {
                for (Class clazz2 : classes2) {
                    if (clazz.getName().equals("java.lang.Object") || !clazz.getName().equals(clazz2.getName())) continue;
                    return rsc;
                }
            }
        }
        return null;
    }

    public List<Object> getResources() {
        return this.resources;
    }
}

