/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.generic.application.configuration;

import fr.emac.gind.generic.application.configuration.EnvironmentCommandWithoutLog;
import io.dropwizard.core.Application;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.setup.Environment;
import java.util.EventListener;
import net.sourceforge.argparse4j.inf.Namespace;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerCommandWithoutLog<T extends Configuration>
extends EnvironmentCommandWithoutLog<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerCommandWithoutLog.class);
    private final Class<T> configurationClass;

    public ServerCommandWithoutLog(Application<T> application) {
        this(application, "serverWithoutLog", "Runs the Dropwizard application wihtout as an HTTP server");
    }

    protected ServerCommandWithoutLog(Application<T> application, String name, String description) {
        super(application, name, description);
        this.configurationClass = application.getConfigurationClass();
    }

    @Override
    protected Class<T> getConfigurationClass() {
        return this.configurationClass;
    }

    @Override
    protected void run(Environment environment, Namespace namespace, T configuration) throws Exception {
        Server server = configuration.getServerFactory().build(environment);
        try {
            server.addEventListener((EventListener)((Object)new LifeCycleListener()));
            this.cleanupAsynchronously();
            server.start();
        }
        catch (Exception e) {
            LOGGER.error("Unable to start server, shutting down", (Throwable)e);
            try {
                server.stop();
            }
            catch (Exception e1) {
                LOGGER.warn("Failure during stop server", (Throwable)e1);
            }
            try {
                this.cleanup();
            }
            catch (Exception e2) {
                LOGGER.warn("Failure during cleanup", (Throwable)e2);
            }
            throw e;
        }
    }

    private class LifeCycleListener
    extends AbstractLifeCycle.AbstractLifeCycleListener {
        private LifeCycleListener() {
        }

        public void lifeCycleStopped(LifeCycle event) {
            ServerCommandWithoutLog.this.cleanup();
        }
    }
}

