/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.r.ioda;

import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.ws.LocalRegistry;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.event.broker.EventBrokerWebService;
import fr.emac.gind.event.broker.SubscriberBrokerManagerImpl;
import fr.emac.gind.event.consumer.NotificationConsumerWebService;
import fr.emac.gind.event.producer.NotificationManagerImpl;
import fr.emac.gind.generic.application.DWApplicationService;
import fr.emac.gind.generic.application.utils.RestResourceManager;
import fr.emac.gind.r.ioda.RIODAApplicationContext;
import fr.emac.gind.r.ioda.RIODANotifierClient;
import fr.emac.gind.r.ioga.RIOGAService;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.setup.Environment;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RIODAService
extends RIOGAService {
    private static Logger LOG = LoggerFactory.getLogger((String)RIODAService.class.getName());
    private NotificationConsumerWebService governanceConsumer = null;

    public RIODAService() throws Exception {
        this(new HashMap<String, Object>());
    }

    public RIODAService(Map<String, Object> context) throws Exception {
        super(context);
    }

    public String getName() {
        return "r-ioda";
    }

    public String getRedirection() {
        return "/rioda";
    }

    public RIODAApplicationContext createApplicationContext() throws Exception {
        return new RIODAApplicationContext((DWApplicationService)this);
    }

    public void doRun(Configuration configuration, Environment environment, RestResourceManager resourcesManager) throws Exception {
        super.doRun(configuration, environment, resourcesManager);
        if (this.conf.getProperties().get("rioda-core-gov-notifier-port") != null) {
            this.createNotifierForCoreGovEvent();
        }
    }

    private void createNotifierForCoreGovEvent() throws Exception {
        String notifierClientAddress = SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.conf.getHost(), (int)Integer.parseInt((String)this.conf.getProperties().get("rioda-core-gov-notifier-port")), (int)Integer.parseInt((String)this.conf.getProperties().get("proxy-port")), (String)"/RIODaNotifierForGovernance");
        final RIODANotifierClient notifier = new RIODANotifierClient(notifierClientAddress, WEB_SOCKET_COMMAND, this.getName());
        this.governanceConsumer = new NotificationConsumerWebService();
        this.governanceConsumer.start((Map)new HashMap<String, Object>(this){
            final /* synthetic */ RIODAService this$0;
            {
                this.this$0 = this$0;
                this.put("host", this.this$0.conf.getProperties().get("host"));
                this.put("port", this.this$0.conf.getProperties().get("rioda-core-gov-notifier-port"));
                this.put("serviceName", "RIODaNotifierForGovernance");
                this.put("notifierClient", notifier);
            }
        });
        if (LocalRegistry.getInstance().findWS(EventBrokerWebService.class) != null) {
            EventBrokerWebService eventBrokerWebService = (EventBrokerWebService)LocalRegistry.getInstance().findWS(EventBrokerWebService.class);
            SubscriberBrokerManagerImpl eventBrokerNotifier = (SubscriberBrokerManagerImpl)eventBrokerWebService.getImplementation(SubscriberBrokerManagerImpl.class);
            notifier.subscribeOn((NotificationManagerImpl)eventBrokerNotifier, new QName("http://www.gind.emac.fr/EventType", "allInterpretationEngineTopic"));
            notifier.subscribeOn((NotificationManagerImpl)eventBrokerNotifier, new QName("http://www.gind.emac.fr/EventType", "similarityNearLinkTopic"));
        } else {
            String brokerSubscribeAddress = (String)this.conf.getProperties().get("event-broker");
            notifier.subscribeOn(brokerSubscribeAddress, new QName("http://www.gind.emac.fr/EventType", "allInterpretationEngineTopic"));
            notifier.subscribeOn(brokerSubscribeAddress, new QName("http://www.gind.emac.fr/EventType", "similarityNearLinkTopic"));
        }
    }

    public void stop() throws Exception {
        super.stop();
        if (this.governanceConsumer != null) {
            this.governanceConsumer.stop();
        }
    }
}

