/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.r.ioda;

import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.eventtype.GJaxbAddEdgeEvent;
import fr.emac.gind.eventtype.GJaxbAddNodeEvent;
import fr.emac.gind.eventtype.GJaxbPublishAndUpublishModelEvent;
import fr.emac.gind.eventtype.GJaxbPublishModelEvent;
import fr.emac.gind.eventtype.GJaxbRemoveEdgeEvent;
import fr.emac.gind.eventtype.GJaxbRemoveNodeEvent;
import fr.emac.gind.eventtype.GJaxbSimilarityNearLinkEvent;
import fr.emac.gind.eventtype.GJaxbUnpublishModelEvent;
import fr.emac.gind.eventtype.GJaxbUpdateEdgeEvent;
import fr.emac.gind.eventtype.GJaxbUpdateNodeEvent;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.sharedOptions.GJaxbNotification;
import fr.emac.gind.websocket.command.WebsocketCommand;
import fr.emac.gind.websocket.command.data.GJaxbGetResult;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotify;
import jakarta.jws.WebService;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@WebService(serviceName="NotifierClientService", portName="NotifierClientEndpoint", targetNamespace="http://www.gind.emac.fr/notifier", wsdlLocation="wsdl/notifier.wsdl", endpointInterface="fr.emac.gind.notifier.NotifierClient")
public class RIODANotifierClient
extends AbstractNotifierClient {
    private static Logger LOG = LoggerFactory.getLogger((String)RIODANotifierClient.class.getName());
    private WebsocketCommand wEB_SOCKET_COMMAND = null;
    private String name = null;

    public RIODANotifierClient(String address, WebsocketCommand wEB_SOCKET_COMMAND, String name) throws Exception {
        super(address);
        this.wEB_SOCKET_COMMAND = wEB_SOCKET_COMMAND;
        this.name = name;
    }

    public void notify(GJaxbNotify notify) {
        try {
            Document doc = WSNHelper.getInstance().getFirstMessageInNotification(notify);
            String json = null;
            String collaborationName = null;
            String knowledgeName = null;
            if (doc.getDocumentElement().getLocalName().equals("addNodeEvent")) {
                event = (GJaxbAddNodeEvent)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbAddNodeEvent.class);
                collaborationName = event.getCollaborationName();
                knowledgeName = event.getKnowledgeSpaceName();
                json = JSONJAXBContext.getInstance().marshallAnyElement((Object)event);
            } else if (doc.getDocumentElement().getLocalName().equals("updateNodeEvent")) {
                event = (GJaxbUpdateNodeEvent)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbUpdateNodeEvent.class);
                collaborationName = event.getCollaborationName();
                knowledgeName = event.getKnowledgeSpaceName();
                json = JSONJAXBContext.getInstance().marshallAnyElement((Object)event);
            } else if (doc.getDocumentElement().getLocalName().equals("removeNodeEvent")) {
                event = (GJaxbRemoveNodeEvent)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbRemoveNodeEvent.class);
                collaborationName = event.getCollaborationName();
                knowledgeName = event.getKnowledgeSpaceName();
                json = JSONJAXBContext.getInstance().marshallAnyElement((Object)event);
            } else if (doc.getDocumentElement().getLocalName().equals("addEdgeEvent")) {
                event = (GJaxbAddEdgeEvent)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbAddEdgeEvent.class);
                collaborationName = event.getCollaborationName();
                knowledgeName = event.getKnowledgeSpaceName();
                json = JSONJAXBContext.getInstance().marshallAnyElement((Object)event);
            } else if (doc.getDocumentElement().getLocalName().equals("updateEdgeEvent")) {
                event = (GJaxbUpdateEdgeEvent)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbUpdateEdgeEvent.class);
                collaborationName = event.getCollaborationName();
                knowledgeName = event.getKnowledgeSpaceName();
                json = JSONJAXBContext.getInstance().marshallAnyElement((Object)event);
            } else if (doc.getDocumentElement().getLocalName().equals("removeEdgeEvent")) {
                event = (GJaxbRemoveEdgeEvent)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbRemoveEdgeEvent.class);
                collaborationName = event.getCollaborationName();
                knowledgeName = event.getKnowledgeSpaceName();
                json = JSONJAXBContext.getInstance().marshallAnyElement((Object)event);
            } else if (doc.getDocumentElement().getLocalName().equals("publishModelEvent")) {
                event = (GJaxbPublishModelEvent)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbPublishModelEvent.class);
                collaborationName = event.getCollaborationName();
                knowledgeName = event.getKnowledgeSpaceName();
                json = JSONJAXBContext.getInstance().marshallAnyElement((Object)event);
            } else if (doc.getDocumentElement().getLocalName().equals("unpublishModelEvent")) {
                event = (GJaxbUnpublishModelEvent)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbUnpublishModelEvent.class);
                collaborationName = event.getCollaborationName();
                knowledgeName = event.getKnowledgeSpaceName();
                json = JSONJAXBContext.getInstance().marshallAnyElement((Object)event);
            } else if (doc.getDocumentElement().getLocalName().equals("publishAndUpublishModelEvent")) {
                event = (GJaxbPublishAndUpublishModelEvent)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbPublishAndUpublishModelEvent.class);
                collaborationName = event.getCollaborationName();
                knowledgeName = event.getKnowledgeSpaceName();
                json = JSONJAXBContext.getInstance().marshallAnyElement((Object)event);
            } else if (doc.getDocumentElement().getLocalName().equals("similarityNearLinkEvent")) {
                event = (GJaxbSimilarityNearLinkEvent)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbSimilarityNearLinkEvent.class);
                collaborationName = event.getCollaborationName();
                knowledgeName = event.getKnowledgeSpaceName();
                json = JSONJAXBContext.getInstance().marshallAnyElement((Object)event);
            } else {
                LOG.warn("Event not take into a charge: " + doc.getDocumentElement().getLocalName());
            }
            if (json != null && collaborationName != null && knowledgeName != null) {
                String cleanJson = json.replace("##application_name##", this.name);
                Map mapInfo = WSNHelper.getInstance().getAdditionalInformationInNotification(notify);
                JSONObject jsonResult = new JSONObject();
                jsonResult.put("event", (Object)cleanJson);
                jsonResult.put("createAt", (Object)((Element)mapInfo.get(new QName("http://www.gind.emac.fr", "createAt"))).getTextContent());
                jsonResult.put("sendAt", (Object)((Element)mapInfo.get(new QName("http://www.gind.emac.fr", "sendAt"))).getTextContent());
                GJaxbGetResult request = new GJaxbGetResult();
                request.setWebsocketId("/rioda/" + RegExpHelper.toRegexFriendlyName((String)collaborationName).hashCode() + "/" + RegExpHelper.toRegexFriendlyName((String)knowledgeName).hashCode());
                request.setJsonResult(jsonResult.toString());
                if (mapInfo.get(new QName("http://www.gind.emac.fr", "context")) != null) {
                    Element context = (Element)mapInfo.get(new QName("http://www.gind.emac.fr", "context"));
                    List notifElmts = DOMUtil.getInstance().findElementsByNameWithoutNS(context, "notification_option", false);
                    if (notifElmts != null && !notifElmts.isEmpty()) {
                        String notification_option = ((Element)DOMUtil.getInstance().findElementsByNameWithoutNS(context, "notification_option", false).get(0)).getTextContent();
                        jsonResult.put("notification_option", (Object)notification_option);
                        GJaxbNotification notifsParams = (GJaxbNotification)JSONJAXBContext.getInstance().unmarshall(notification_option, GJaxbNotification.class);
                        request.setNotificationProvokedBy(notifsParams.getNotificationProvokedBy());
                    }
                }
                this.wEB_SOCKET_COMMAND.getResult(request);
            }
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }
}

