/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.r.iomega.websocket;

import fr.emac.gind.governance.ai.command.assistant.GJaxbCommandResponse;
import fr.emac.gind.governance.ai.command.assistant.GJaxbExceptedWindows;
import fr.emac.gind.governance.ai.command.assistant.GJaxbToolDef;
import fr.emac.gind.governance.ai.command.assistant.GJaxbToolParam;
import fr.emac.gind.governance.ai.command.assistant.GJaxbToolsInfo;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.AiContext;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.GoodTools;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.MapUiTools;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.NewsTools;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.PeopleTools;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.ProblemsTools;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.SensorTools;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.SolutionTools;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.ToolsManager;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.UserTools;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.WeatherTools;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.WindowTools;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.rio.dw.resources.AssistantResource;
import fr.emac.gind.sharedOptions.GJaxbSelectedKnowledgeSpace;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.Session;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealtimeProxyEndpoint
implements Session.Listener.AutoDemanding {
    private static final Logger LOG = LoggerFactory.getLogger(RealtimeProxyEndpoint.class);
    private final OkHttpClient http;
    private final String apiKey;
    private final String model = "gpt-realtime";
    private Session downstream;
    private WebSocket upstream;
    private final AssistantResource assistantResource;
    private String instructions = null;
    private JSONArray toolsArray = null;
    private final Map<String, StringBuilder> toolArgsBuf = new ConcurrentHashMap<String, StringBuilder>();
    private final Map<String, String> toolNameById = new ConcurrentHashMap<String, String>();

    public RealtimeProxyEndpoint(AssistantResource assistantResource) throws Exception {
        try {
            String OPENAI_CHATGPT_API_KEY;
            this.assistantResource = assistantResource;
            this.http = new OkHttpClient.Builder().pingInterval(Duration.ofSeconds(15L)).build();
            this.apiKey = OPENAI_CHATGPT_API_KEY = System.getenv("OPENAI_CHATGPT_API_KEY");
            GJaxbToolsInfo toolsInfo = ToolsManager.getInstance().getToolsInfoForRealtimeSystem();
            this.instructions = toolsInfo.getPrompt();
            this.toolsArray = new JSONArray();
            for (GJaxbToolDef tool : toolsInfo.getTools()) {
                JSONObject openaiTool = new JSONObject();
                openaiTool.put("type", (Object)"function");
                openaiTool.put("name", (Object)tool.getMethodName());
                openaiTool.put("description", (Object)tool.getDescription());
                if (!tool.getParams().isEmpty()) {
                    JSONObject parameters = new JSONObject();
                    openaiTool.put("parameters", (Object)parameters);
                    parameters.put("type", (Object)"object");
                    JSONObject properties = new JSONObject();
                    JSONArray required = new JSONArray();
                    for (GJaxbToolParam param : tool.getParams()) {
                        String type;
                        JSONObject property = new JSONObject();
                        String string = type = param.getType().toLowerCase().startsWith("gjaxb") ? "object" : param.getType().toLowerCase();
                        if (type.equals("language")) {
                            type = "string";
                        }
                        property.put("type", (Object)type);
                        property.put("description", (Object)"");
                        properties.put(param.getName(), (Object)property);
                        required.put((Object)param.getName());
                    }
                    parameters.put("properties", (Object)properties);
                    parameters.put("required", (Object)required);
                    parameters.put("additionalProperties", false);
                }
                this.toolsArray.put((Object)openaiTool);
            }
            System.out.println("initialized !!!");
        }
        catch (Exception e) {
            LOG.error("Initialization Error RealtimeProxyEndpoint", (Throwable)e);
            throw e;
        }
    }

    public void onWebSocketOpen(Session session) {
        this.downstream = session;
        Request req = new Request.Builder().url("wss://api.openai.com/v1/realtime?model=gpt-realtime").addHeader("Authorization", "Bearer " + this.apiKey).addHeader("OpenAI-Beta", "realtime=v1").build();
        this.upstream = this.http.newWebSocket(req, new WebSocketListener(){

            public void onOpen(WebSocket ws, Response resp) {
                System.out.println("******* REALTIME : OPENAI Connection opened");
            }

            public void onMessage(WebSocket ws, String text) {
                RealtimeProxyEndpoint.this.handleUpstreamText(ws, text);
            }

            public void onMessage(WebSocket ws, ByteString bytes) {
                Session s = RealtimeProxyEndpoint.this.downstream;
                if (s != null && s.isOpen()) {
                    ByteBuffer buf = bytes.asByteBuffer();
                    s.sendBinary(buf, Callback.from(() -> {}, x -> x.printStackTrace()));
                }
                System.out.println("******* OPENAI EVENT (bytes) len=" + bytes.size());
            }

            public void onClosing(WebSocket ws, int code, String reason) {
                RealtimeProxyEndpoint.this.tryCloseDownstream(code, reason);
                ws.close(code, reason);
                System.out.println("******* REALTIME : OPENAI onClosing");
            }

            public void onClosed(WebSocket ws, int code, String reason) {
                RealtimeProxyEndpoint.this.tryCloseDownstream(code, reason);
                System.out.println("******* REALTIME : OPENAI onClosed");
            }

            public void onFailure(WebSocket ws, Throwable t, Response resp) {
                RealtimeProxyEndpoint.this.tryCloseDownstream(1011, "Upstream failure: " + t.getMessage());
                System.out.println("******* REALTIME : OPENAI Failure => " + t.getMessage());
            }
        });
    }

    public void onWebSocketText(String message) {
        if (this.upstream != null) {
            if (message.contains("\"type\":\"session.update\"")) {
                JSONObject openaiRequest = new JSONObject(message);
                JSONObject openaiSession = openaiRequest.getJSONObject("session");
                String baseInstr = this.instructions != null ? this.instructions + "\n\n" : "";
                openaiSession.put("instructions", (Object)baseInstr);
                openaiSession.put("tools", (Object)this.toolsArray);
                openaiSession.put("modalities", (Object)new JSONArray().put((Object)"text").put((Object)"audio"));
                String collaborationName = (String)openaiRequest.remove("collaborationName");
                String knowledgeSpaceName = (String)openaiRequest.remove("knowledgeSpaceName");
                GJaxbSelectedKnowledgeSpace sks = new GJaxbSelectedKnowledgeSpace();
                sks.setCollaborationName(collaborationName);
                sks.setKnowledgeName(knowledgeSpaceName);
                AiContext aiContext = new AiContext(sks);
                ToolsManager.getInstance().setContext(aiContext);
                message = openaiRequest.toString();
                System.out.println("new message: " + message);
            }
            this.upstream.send(message);
        }
        System.out.println("******* REALTIME (USER MSG REQUEST (text)) : " + message);
    }

    public void onWebSocketBinary(ByteBuffer payload, Callback callback) {
        if (this.upstream != null) {
            this.upstream.send(ByteString.of((ByteBuffer)payload));
        }
        System.out.println("******* REALTIME (USER MSG REQUEST (bytes)) payload=" + String.valueOf(payload));
    }

    public void onWebSocketClose(int statusCode, String reason, Callback callback) {
        if (this.upstream != null) {
            try {
                this.upstream.close(statusCode, reason);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.upstream = null;
        }
        System.out.println("******* REALTIME : downstream onClose");
    }

    public void onWebSocketError(Throwable cause) {
        this.tryCloseDownstream(1011, "Proxy error: " + cause.getMessage());
        if (this.upstream != null) {
            try {
                this.upstream.close(1011, "Proxy error");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.upstream = null;
        }
        System.out.println("******* REALTIME : downstream onError " + cause.getMessage());
    }

    private void tryCloseDownstream(int code, String reason) {
        Session s = this.downstream;
        if (s != null && s.isOpen()) {
            s.close(1000, reason, Callback.from(() -> {}, x -> LOG.debug("\u00c9chec fermeture WS : {}", (Object)x.toString())));
        }
    }

    private void handleUpstreamText(WebSocket ws, String text) {
        try {
            JSONObject ev = new JSONObject(text);
            String type = ev.optString("type", "");
            System.out.println("******* OPENAI EVENT: " + type);
            switch (type) {
                case "response.created": {
                    this.forwardDownstream(text);
                    break;
                }
                case "response.completed": {
                    this.forwardDownstream(text);
                    break;
                }
                case "error": {
                    this.forwardDownstream(text);
                    break;
                }
                case "response.function_call.created": {
                    JSONObject fc = ev.optJSONObject("function_call");
                    if (fc != null) {
                        String callId = fc.optString("id", null);
                        String name = fc.optString("name", null);
                        if (callId != null) {
                            this.toolArgsBuf.put(callId, new StringBuilder());
                            if (name != null) {
                                this.toolNameById.put(callId, name);
                            }
                        }
                    }
                    this.forwardDownstream(text);
                    break;
                }
                case "response.function_call_arguments.delta": 
                case "response.tool_call_arguments.delta": {
                    String callId = ev.optString("call_id", null);
                    String delta = ev.optString("delta", "");
                    if (callId != null) {
                        String maybeName = ev.optString("name", null);
                        if (maybeName != null && !maybeName.isEmpty()) {
                            this.toolNameById.put(callId, maybeName);
                        }
                        this.toolArgsBuf.computeIfAbsent(callId, k -> new StringBuilder()).append(delta);
                    }
                    this.forwardDownstream(text);
                    break;
                }
                case "response.function_call_arguments.done": 
                case "response.tool_call_arguments.done": {
                    String callId = ev.optString("call_id", null);
                    String toolName = this.toolNameById.get(callId);
                    if ((toolName == null || toolName.isEmpty()) && (toolName = ev.optString("name", null)) != null) {
                        this.toolNameById.put(callId, toolName);
                    }
                    String argsStr = this.toolArgsBuf.getOrDefault(callId, new StringBuilder()).toString();
                    if (callId != null) {
                        String resultJsonStr;
                        JSONObject argsJson;
                        try {
                            argsJson = argsStr.isEmpty() ? new JSONObject() : new JSONObject(argsStr);
                        }
                        catch (Exception parseErr) {
                            String errOut = new JSONObject().put("status", (Object)"error").put("message", (Object)"Invalid tool arguments JSON").put("data", (Object)new JSONObject().put("raw", (Object)argsStr)).toString();
                            this.sendToolOutputThenForceEmitQueued(callId, errOut, this.upstream);
                            break;
                        }
                        try {
                            resultJsonStr = this.executeTool(toolName, argsJson).toString();
                        }
                        catch (Exception toolErr) {
                            resultJsonStr = new JSONObject().put("status", (Object)"error").put("message", (Object)toolErr.getMessage()).toString();
                        }
                        this.sendToolOutputThenForceEmitQueued(callId, resultJsonStr, this.upstream);
                        this.toolArgsBuf.remove(callId);
                        this.toolNameById.remove(callId);
                        break;
                    }
                    this.forwardDownstream(text);
                    break;
                }
                default: {
                    this.forwardDownstream(text);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.forwardDownstream(text);
        }
    }

    private void forwardDownstream(String text) {
        Session s = this.downstream;
        if (s != null && s.isOpen()) {
            s.sendText(text, Callback.from(() -> {}, x -> x.printStackTrace()));
        }
    }

    private void sendToolOutputThenForceEmitQueued(String callId, String resultJsonStr, WebSocket ws) {
        try {
            JSONObject toolOut = new JSONObject().put("type", (Object)"conversation.item.create").put("item", (Object)new JSONObject().put("type", (Object)"function_call_output").put("call_id", (Object)callId).put("output", (Object)resultJsonStr));
            ws.send(toolOut.toString());
            System.out.println("******* SENT: function_call_output call_id=" + callId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JSONObject executeTool(String functionName, JSONObject args) throws Exception {
        GJaxbCommandResponse command = null;
        switch (functionName) {
            case "detectUser": {
                command = ((UserTools)ToolsManager.getInstance().getToolByClass(UserTools.class)).detectUser(args.optString("userName"), UserTools.Language.valueOf((String)args.optString("userLanguage")));
                break;
            }
            case "showMap": {
                command = ((MapUiTools)ToolsManager.getInstance().getToolByClass(MapUiTools.class)).showMap(UserTools.Language.valueOf((String)args.optString("userLanguage")));
                break;
            }
            case "hideMap": {
                command = ((MapUiTools)ToolsManager.getInstance().getToolByClass(MapUiTools.class)).hideMap(UserTools.Language.valueOf((String)args.optString("userLanguage")));
                break;
            }
            case "zoomToPlace": {
                command = ((MapUiTools)ToolsManager.getInstance().getToolByClass(MapUiTools.class)).zoomToPlace(args.optString("place"), UserTools.Language.valueOf((String)args.optString("userLanguage")));
                break;
            }
            case "findPersonLocation": {
                command = ((PeopleTools)ToolsManager.getInstance().getToolByClass(PeopleTools.class)).findPersonLocation(args.optString("firstName"), args.optString("lastName"), UserTools.Language.valueOf((String)args.optString("userLanguage")));
                break;
            }
            case "whoIsThisPerson": {
                command = ((PeopleTools)ToolsManager.getInstance().getToolByClass(PeopleTools.class)).whoIsThisPerson(args.optString("firstName"), args.optString("lastName"), UserTools.Language.valueOf((String)args.optString("userLanguage")));
                break;
            }
            case "findGoodLocation": {
                command = ((GoodTools)ToolsManager.getInstance().getToolByClass(GoodTools.class)).findGoodLocation(args.optString("goodName"), UserTools.Language.valueOf((String)args.optString("userLanguage")));
                break;
            }
            case "whatIsThisGood": {
                command = (GJaxbCommandResponse)JSONJAXBContext.getInstance().unmarshall(((GoodTools)ToolsManager.getInstance().getToolByClass(GoodTools.class)).whatIsThisGood(args.optString("goodName"), UserTools.Language.valueOf((String)args.optString("userLanguage"))), GJaxbCommandResponse.class);
                break;
            }
            case "findMonitoredAssets": {
                command = (GJaxbCommandResponse)JSONJAXBContext.getInstance().unmarshall(((SensorTools)ToolsManager.getInstance().getToolByClass(SensorTools.class)).findMonitoredAssets(UserTools.Language.valueOf((String)args.optString("userLanguage"))), GJaxbCommandResponse.class);
                break;
            }
            case "giveNews": {
                command = ((NewsTools)ToolsManager.getInstance().getToolByClass(NewsTools.class)).giveNews(args.optString("place"), UserTools.Language.valueOf((String)args.optString("userLanguage")));
                break;
            }
            case "giveWheatherForecast": {
                command = ((WeatherTools)ToolsManager.getInstance().getToolByClass(WeatherTools.class)).giveWheatherForecast(args.optString("place"), UserTools.Language.valueOf((String)args.optString("userLanguage")));
                break;
            }
            case "detectProblemsFromThisInformation": {
                command = ((ProblemsTools)ToolsManager.getInstance().getToolByClass(ProblemsTools.class)).detectProblemsFromThisInformation(args.optString("user_message"), args.optString("place"), UserTools.Language.valueOf((String)args.optString("userLanguage")));
                break;
            }
            case "detectProblemsFromNewsAndWeatherForecast": {
                command = ((ProblemsTools)ToolsManager.getInstance().getToolByClass(ProblemsTools.class)).detectProblemsFromNewsAndWeatherForecast(args.optJSONObject("news") != null ? (GJaxbCommandResponse)JSONJAXBContext.getInstance().unmarshall(args.getJSONObject("news").toString(), GJaxbCommandResponse.class) : null, args.optJSONObject("weatherForecast") != null ? (GJaxbCommandResponse)JSONJAXBContext.getInstance().unmarshall(args.getJSONObject("weatherForecast").toString(), GJaxbCommandResponse.class) : null, args.optString("place"), UserTools.Language.valueOf((String)args.optString("userLanguage")));
                break;
            }
            case "showAlerts": {
                command = ((ProblemsTools)ToolsManager.getInstance().getToolByClass(ProblemsTools.class)).showAlerts(UserTools.Language.valueOf((String)args.optString("userLanguage")));
                break;
            }
            case "closeAllWindows": {
                command = ((WindowTools)ToolsManager.getInstance().getToolByClass(WindowTools.class)).closeAllWindows(UserTools.Language.valueOf((String)args.optString("userLanguage")));
                break;
            }
            case "closeAllWindowsExcept": {
                command = ((WindowTools)ToolsManager.getInstance().getToolByClass(WindowTools.class)).closeAllWindowsExcept(args.optJSONObject("exceptedWindowsNamesList") != null ? (GJaxbExceptedWindows)JSONJAXBContext.getInstance().unmarshall(args.optJSONObject("exceptedWindowsNamesList").toString(), GJaxbExceptedWindows.class) : null, UserTools.Language.valueOf((String)args.optString("userLanguage")));
                break;
            }
            case "closeWindow": {
                command = ((WindowTools)ToolsManager.getInstance().getToolByClass(WindowTools.class)).closeWindow(args.optString("windowName"), UserTools.Language.valueOf((String)args.optString("userLanguage")));
                break;
            }
            case "runFirstSolution": {
                command = ((SolutionTools)ToolsManager.getInstance().getToolByClass(SolutionTools.class)).runFirstSolution(UserTools.Language.valueOf((String)args.optString("userLanguage")));
                break;
            }
            case "runCampaign": {
                command = ((SolutionTools)ToolsManager.getInstance().getToolByClass(SolutionTools.class)).runCampaign(UserTools.Language.valueOf((String)args.optString("userLanguage")));
                break;
            }
            default: {
                throw new Exception("Impossible to find function: " + functionName);
            }
        }
        if (command == null) {
            throw new Exception("Command not created for function: " + functionName);
        }
        JSONObject res = new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)command));
        System.out.println("\n\n\n\nTool executed: " + functionName + " with args: " + args.toString() + " => result: \n" + res.toString() + "\n\n\n\n");
        return res;
    }
}

