/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources;

import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.gov.ai.command.assistant.AiCommandAssistant;
import fr.emac.gind.gov.ai.command.assistant.FaultMessage;
import fr.emac.gind.governance.ai.command.assistant.GJaxbAssistantRequest;
import fr.emac.gind.governance.ai.command.assistant.GJaxbAssistantResponse;
import fr.emac.gind.governance.ai.command.assistant.GJaxbGetToolsInfo;
import fr.emac.gind.governance.ai.command.assistant.GJaxbGetToolsInfoResponse;
import fr.emac.gind.governance.ai.command.assistant.client.AiCommandAssistantClient;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import org.json.JSONObject;

@Path(value="/{app}/api/assistant/")
@Produces(value={"application/json"})
public class AssistantResource {
    private AiCommandAssistant commandAssistant = null;

    public AssistantResource(Configuration conf) throws Exception {
        this.commandAssistant = AiCommandAssistantClient.createClient((String)((String)conf.getProperties().get("governance")).replace("/gov", "/GovAICommandAssistant"));
    }

    public AiCommandAssistant getCommandAssistant() {
        return this.commandAssistant;
    }

    @GET
    @Path(value="getToolsInfo")
    public GJaxbGetToolsInfoResponse getToolsInfo(@Auth DWUser user, GJaxbGetToolsInfo req) throws FaultMessage {
        return this.commandAssistant.getToolsInfo(req);
    }

    @POST
    @Path(value="handle")
    @Consumes(value={"application/json"})
    public String handle(@Auth DWUser user, GJaxbAssistantRequest req) throws Exception {
        req.setCollaborationName(user.getCurrentCollaborationName());
        req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
        GJaxbAssistantResponse resp = this.commandAssistant.handle(req);
        return new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)resp)).getJSONObject("assistantResponse").toString();
    }
}

