/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.r.iomega;

import fr.emac.gind.generic.application.DWApplicationService;
import fr.emac.gind.generic.application.utils.RestResourceManager;
import fr.emac.gind.r.ioda.RIODAService;
import fr.emac.gind.r.iomega.RIOMEGAApplicationContext;
import fr.emac.gind.r.iomega.websocket.RealtimeProxyServlet;
import fr.emac.gind.rio.dw.resources.AssistantResource;
import fr.emac.gind.rio.dw.resources.OpenAIAudioResource;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.setup.Environment;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletRegistration;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RIOMEGAService
extends RIODAService {
    private static Logger LOG = LoggerFactory.getLogger((String)RIOMEGAService.class.getName());
    private OpenAIAudioResource openAISTT_TTSResource = null;
    private AssistantResource assistantResource = null;

    public RIOMEGAService() throws Exception {
        this(new HashMap<String, Object>());
    }

    public RIOMEGAService(Map<String, Object> context) throws Exception {
        super(context);
    }

    public String getName() {
        return "r-iomega";
    }

    public String getRedirection() {
        return "/riomega";
    }

    public RIOMEGAApplicationContext createApplicationContext() throws Exception {
        return new RIOMEGAApplicationContext((DWApplicationService)this);
    }

    public void doRun(Configuration configuration, Environment environment, RestResourceManager resourcesManager) throws Exception {
        super.doRun(configuration, environment, resourcesManager);
        this.openAISTT_TTSResource = new OpenAIAudioResource(this.conf);
        resourcesManager.addResource((Object)this.openAISTT_TTSResource);
        this.assistantResource = new AssistantResource(this.conf);
        resourcesManager.addResource((Object)this.assistantResource);
        ServletRegistration.Dynamic websocket = environment.servlets().addServlet("openai-ws", (Servlet)new RealtimeProxyServlet(this.assistantResource));
        websocket.setAsyncSupported(true);
        websocket.addMapping(new String[]{"/ws/openai/audio/realtime"});
    }

    public void stop() throws Exception {
        super.stop();
    }
}

