/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.launcher.Configuration;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="/{app}/openai/audio")
@Produces(value={"application/json"})
public class OpenAIAudioResource {
    private final String apiKey;
    private final OkHttpClient http;
    private final ObjectMapper mapper = new ObjectMapper();

    public OpenAIAudioResource(Configuration conf) {
        String OPENAI_CHATGPT_API_KEY;
        this.apiKey = OPENAI_CHATGPT_API_KEY = System.getenv("OPENAI_CHATGPT_API_KEY");
        this.http = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).build();
    }

    @POST
    @Path(value="/tts")
    public jakarta.ws.rs.core.Response textToSpeech(@Auth DWUser user, TtsRequest req) throws IOException {
        if (req.input == null || req.input.isBlank()) {
            return jakarta.ws.rs.core.Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing text").build();
        }
        String bodyJson = this.mapper.writeValueAsString((Object)req);
        MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
        RequestBody body = RequestBody.create((String)bodyJson, (MediaType)JSON);
        Request request = new Request.Builder().url("https://api.openai.com/v1/audio/speech").header("Authorization", "Bearer " + this.apiKey).header("Content-Type", "application/json").post(body).build();
        try (ResponseBody responseBody = this.http.newCall(request).execute().body();){
            if (responseBody == null) {
                jakarta.ws.rs.core.Response response = jakarta.ws.rs.core.Response.serverError().entity((Object)"No response from OpenAI").build();
                return response;
            }
            byte[] audioBytes = responseBody.bytes();
            String string = jakarta.ws.rs.core.Response.ok((Object)audioBytes, (String)(switch (req.response_format) {
                case "wav" -> "audio/wav";
                case "opus" -> "audio/ogg";
                case "aac" -> "audio/aac";
                case "flac" -> "audio/flac";
                default -> "audio/mpeg";
            })).header("Cache-Control", (Object)"no-store").build();
            return string;
        }
    }

    @POST
    @Path(value="/stt")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public jakarta.ws.rs.core.Response speechToText(@Auth DWUser user, @FormDataParam(value="file") InputStream fileInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail) throws IOException {
        if (fileInputStream == null || fileDetail == null) {
            return jakarta.ws.rs.core.Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{\"error\":\"No file uploaded\"}").build();
        }
        MediaType AUDIO_WEBM = MediaType.get((String)"audio/webm");
        InputStreamRequestBody fileBody = new InputStreamRequestBody(AUDIO_WEBM, fileInputStream);
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("model", "gpt-4o-transcribe").addFormDataPart("file", fileDetail.getFileName(), (RequestBody)fileBody).build();
        Request request = new Request.Builder().url("https://api.openai.com/v1/audio/transcriptions").header("Authorization", "Bearer " + this.apiKey).post((RequestBody)requestBody).build();
        try (ResponseBody responseBody = this.http.newCall(request).execute().body();){
            if (responseBody == null) {
                jakarta.ws.rs.core.Response response = jakarta.ws.rs.core.Response.serverError().entity((Object)"{\"error\":\"No response from OpenAI\"}").build();
                return response;
            }
            jakarta.ws.rs.core.Response response = jakarta.ws.rs.core.Response.ok((Object)responseBody.string(), (String)"application/json").build();
            return response;
        }
    }

    @GET
    @Path(value="/realtime/token")
    public jakarta.ws.rs.core.Response token(@Auth DWUser user) throws Exception {
        String json = "{ \"model\": \"gpt-4o-realtime-preview\", \"voice\": \"verse\"}";
        MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
        RequestBody body = RequestBody.create((String)"{ \"model\": \"gpt-4o-realtime-preview\", \"voice\": \"verse\"}", (MediaType)JSON);
        Request req = new Request.Builder().url("https://api.openai.com/v1/realtime/sessions").post(body).header("Authorization", "Bearer " + this.apiKey).header("Content-Type", "application/json").build();
        try (Response resp = this.http.newCall(req).execute();){
            String payload;
            ResponseBody respBody = resp.body();
            String string = payload = respBody != null ? respBody.string() : "";
            if (!resp.isSuccessful()) {
                jakarta.ws.rs.core.Response response = jakarta.ws.rs.core.Response.status((int)resp.code()).entity(payload.isEmpty() ? "HTTP " + resp.code() : payload).build();
                return response;
            }
            String token = (String)JsonPath.read((String)payload, (String)"$.client_secret.value", (Predicate[])new Predicate[0]);
            TokenResponse out = new TokenResponse();
            out.token = token;
            jakarta.ws.rs.core.Response response = jakarta.ws.rs.core.Response.ok((Object)out).build();
            return response;
        }
    }

    static class TtsRequest {
        @JsonProperty
        public String input;
        @JsonProperty
        public String voice = "alloy";
        @JsonProperty
        public String response_format = "mp3";
        @JsonProperty
        public String model = "gpt-4o-mini-tts";
        @JsonProperty
        public String instructions = "Speak in a cheerful and positive tone.";

        TtsRequest() {
        }
    }

    static class InputStreamRequestBody
    extends RequestBody {
        private final MediaType contentType;
        private final InputStream inputStream;

        public InputStreamRequestBody(MediaType contentType, InputStream inputStream) {
            this.contentType = contentType;
            this.inputStream = inputStream;
        }

        public MediaType contentType() {
            return this.contentType;
        }

        public void writeTo(BufferedSink sink) throws IOException {
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = this.inputStream.read(buffer)) != -1) {
                sink.write(buffer, 0, bytesRead);
            }
            this.inputStream.close();
        }
    }

    static class TokenResponse {
        @JsonProperty
        public String token;

        TokenResponse() {
        }
    }
}

