/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.r.ioplay;

import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.eventtype.GJaxbAddNodeEvent;
import fr.emac.gind.eventtype.GJaxbRemoveNodeEvent;
import fr.emac.gind.eventtype.GJaxbUpdateNodeEvent;
import fr.emac.gind.gov.core_gov.GJaxbGetNode;
import fr.emac.gind.gov.core_gov.GJaxbGetNodeResponse;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.rio.dw.resources.gov.CoreResource;
import fr.emac.gind.sharedOptions.GJaxbSelectedKnowledgeSpace;
import fr.emac.gind.websocket.command.WebsocketCommand;
import fr.emac.gind.websocket.command.data.GJaxbGetResult;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotify;
import jakarta.jws.WebService;
import java.util.Map;
import javax.xml.namespace.QName;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@WebService(serviceName="NotifierClientService", portName="NotifierClientEndpoint", targetNamespace="http://www.gind.emac.fr/notifier", wsdlLocation="wsdl/notifier.wsdl", endpointInterface="fr.emac.gind.notifier.NotifierClient")
public class RIOPLAYNotifierClient
extends AbstractNotifierClient {
    private static Logger LOG = LoggerFactory.getLogger((String)RIOPLAYNotifierClient.class.getName());
    private WebsocketCommand WEB_SOCKET_COMMAND = null;
    private String name = null;
    private CoreResource coreResource = null;

    public RIOPLAYNotifierClient(String address, WebsocketCommand wEB_SOCKET_COMMAND, String name, CoreResource coreResource) throws Exception {
        super(address);
        this.WEB_SOCKET_COMMAND = wEB_SOCKET_COMMAND;
        this.name = name;
        this.coreResource = coreResource;
    }

    public synchronized void notify(GJaxbNotify notify) {
        try {
            Document doc = WSNHelper.getInstance().getFirstMessageInNotification(notify);
            String json = null;
            String collaborationName = null;
            String knowledgeName = null;
            if (doc.getDocumentElement().getLocalName().equals("addNodeEvent")) {
                event = (GJaxbAddNodeEvent)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbAddNodeEvent.class);
                collaborationName = event.getCollaborationName();
                knowledgeName = event.getKnowledgeSpaceName();
                json = JSONJAXBContext.getInstance().marshallAnyElement((Object)event);
            } else if (doc.getDocumentElement().getLocalName().equals("updateNodeEvent")) {
                event = (GJaxbUpdateNodeEvent)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbUpdateNodeEvent.class);
                collaborationName = event.getCollaborationName();
                knowledgeName = event.getKnowledgeSpaceName();
                if (event != null && event.getNode() != null && (event.getNode().getGeolocation() == null || !event.getNode().getGeolocation().getItemView().isEmpty() && ((GJaxbNode.Geolocation.ItemView)event.getNode().getGeolocation().getItemView().get(0)).isSetRedesign() && ((GJaxbNode.Geolocation.ItemView)event.getNode().getGeolocation().getItemView().get(0)).isRedesign().booleanValue())) {
                    GJaxbGetNode getNode = new GJaxbGetNode();
                    getNode.setId(event.getNode().getId());
                    getNode.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
                    getNode.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
                    getNode.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeName);
                    GJaxbGetNodeResponse resp = this.coreResource.getCoreClient().getNode(getNode);
                    event.setNode(resp.getNode());
                }
                json = JSONJAXBContext.getInstance().marshallAnyElement((Object)event);
            } else if (doc.getDocumentElement().getLocalName().equals("removeNodeEvent")) {
                event = (GJaxbRemoveNodeEvent)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbRemoveNodeEvent.class);
                collaborationName = event.getCollaborationName();
                knowledgeName = event.getKnowledgeSpaceName();
                json = JSONJAXBContext.getInstance().marshallAnyElement((Object)event);
            } else {
                LOG.warn("Event not take into a charge: " + doc.getDocumentElement().getLocalName());
            }
            if (json != null && collaborationName != null && knowledgeName != null) {
                String cleanJson = json.replace("##application_name##", this.name);
                Map mapInfo = WSNHelper.getInstance().getAdditionalInformationInNotification(notify);
                JSONObject jsonResult = new JSONObject();
                jsonResult.put("event", (Object)cleanJson);
                jsonResult.put("createAt", (Object)((Element)mapInfo.get(new QName("http://www.gind.emac.fr", "createAt"))).getTextContent());
                jsonResult.put("sendAt", (Object)((Element)mapInfo.get(new QName("http://www.gind.emac.fr", "sendAt"))).getTextContent());
                GJaxbGetResult request = new GJaxbGetResult();
                request.setWebsocketId("/rioplay/" + RegExpHelper.toRegexFriendlyName((String)collaborationName).hashCode() + "/" + RegExpHelper.toRegexFriendlyName((String)knowledgeName).hashCode());
                request.setJsonResult(jsonResult.toString());
                this.WEB_SOCKET_COMMAND.getResult(request);
            }
        }
        catch (Throwable e) {
            LOG.warn(e.getMessage(), e);
        }
    }
}

