/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources;

import fr.emac.gind.find.gis.client.FindGisClient;
import fr.emac.gind.generic.application.GindWebApplicationException;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.gis.find_gis.FindGis;
import fr.emac.gind.gis.store_gis.GJaxbDeployGeoJSONFile;
import fr.emac.gind.gis.store_gis.GJaxbDeployGeoJSONFileResponse;
import fr.emac.gind.gis.store_gis.GJaxbGetGeoJSONFilesStored;
import fr.emac.gind.gis.store_gis.GJaxbGetGeoJSONFilesStoredResponse;
import fr.emac.gind.gis.store_gis.GJaxbLoadGeoJSONFile;
import fr.emac.gind.gis.store_gis.GJaxbLoadGeoJSONFileResponse;
import fr.emac.gind.gis.store_gis.GJaxbPackage;
import fr.emac.gind.gis.store_gis.GJaxbUndeployGeoJSONFile;
import fr.emac.gind.gis.store_gis.GJaxbUndeployGeoJSONFileResponse;
import fr.emac.gind.gis.store_gis.StoreGis;
import fr.emac.gind.h2gis.gis.H2GisFindGisImpl;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.store.gis.client.StoreGisClient;
import io.dropwizard.auth.Auth;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.util.ByteArrayDataSource;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.json.JSONObject;

@Path(value="/{genericApplication}/geoJSON")
@Produces(value={"application/json"})
public class GeoJSONResource {
    private StoreGis storeGisClient = null;
    private FindGis findGisClient = null;

    public GeoJSONResource(Configuration conf) throws Exception {
        this.storeGisClient = StoreGisClient.createClient((String)((String)conf.getProperties().get("h2gis-server")).replace("h2", "store"));
        this.findGisClient = FindGisClient.createClient((String)((String)conf.getProperties().get("h2gis-server")).replace("h2", "find"), H2GisFindGisImpl.class);
    }

    @POST
    @Path(value="/loadPredefinedGeoJSONFiles")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String loadPredefinedGeoJSONFiles(@Auth DWUser user, List<String> predefinedGeoJSONURL) throws Exception {
        assert (user != null);
        String resp = null;
        try {
            long count = 0L;
            for (String url : predefinedGeoJSONURL) {
                GJaxbLoadGeoJSONFile request = new GJaxbLoadGeoJSONFile();
                request.setUrl(url);
                GJaxbLoadGeoJSONFileResponse response = this.storeGisClient.loadGeoJSONFile(request);
                count += response.getCount();
            }
            JSONObject jc = new JSONObject();
            jc.put("count", count);
            resp = jc.toString();
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return resp;
    }

    @POST
    @Path(value="/deployGeoJSONFiles")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public GJaxbDeployGeoJSONFileResponse deployGeoJSONFiles(@Auth DWUser user, @FormDataParam(value="file") InputStream is, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @QueryParam(value="data") String data) throws Exception {
        GJaxbDeployGeoJSONFileResponse resp = null;
        try {
            ByteArrayDataSource rawData = new ByteArrayDataSource(IOUtils.toByteArray((InputStream)is), "multipart/form-data");
            String name = null;
            GJaxbPackage _package = new GJaxbPackage();
            DataHandler bin = null;
            if (!fileDetail.getFileName().endsWith(".zip")) {
                throw new Exception("This resource must be a zip file: " + fileDetail.getFileName());
            }
            name = fileDetail.getFileName();
            bin = new DataHandler((DataSource)rawData);
            if (bin != null) {
                _package.setZip(bin);
            }
            GJaxbDeployGeoJSONFile request = new GJaxbDeployGeoJSONFile();
            request.setName(name);
            request.setPackage(_package);
            rawData.getInputStream().close();
            resp = this.storeGisClient.deployGeoJSONFile(request);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return resp;
    }

    @GET
    @Path(value="/getGeoJSONFiles")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbGetGeoJSONFilesStoredResponse getGeoJSONFiles(@Auth DWUser user) throws Exception {
        assert (user != null);
        GJaxbGetGeoJSONFilesStoredResponse resp = null;
        try {
            resp = this.storeGisClient.getGeoJSONFilesStored(new GJaxbGetGeoJSONFilesStored());
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return resp;
    }

    @POST
    @Path(value="/undeployGeoJSONFiles")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbUndeployGeoJSONFileResponse undeployGeoJSONFiles(@Auth DWUser user, String tableName) throws Exception {
        assert (user != null);
        GJaxbUndeployGeoJSONFileResponse resp = null;
        try {
            GJaxbUndeployGeoJSONFile request = new GJaxbUndeployGeoJSONFile();
            request.setTableName(tableName);
            resp = this.storeGisClient.undeployGeoJSONFile(request);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return resp;
    }
}

