/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.r.ioplay;

import fr.emac.gind.campaign.manager.server.CampaignManagerSubscriber;
import fr.emac.gind.campaign.manager.server.CampaignManagerWebService;
import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.ws.LocalRegistry;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.commons.utils.ws.StaticJettyServer;
import fr.emac.gind.event.consumer.NotificationConsumerWebService;
import fr.emac.gind.event.producer.NotificationManagerImpl;
import fr.emac.gind.generic.application.DWApplicationService;
import fr.emac.gind.generic.application.utils.RestResourceManager;
import fr.emac.gind.governance.GovernanceWebService;
import fr.emac.gind.r.ioga.RIOGAService;
import fr.emac.gind.r.ioplay.FindGisCallbackIOPlayImpl;
import fr.emac.gind.r.ioplay.RIOPLAYApplicationContext;
import fr.emac.gind.r.ioplay.RIOPLAYNotifierClient;
import fr.emac.gind.rio.dw.resources.GeoJSONResource;
import fr.emac.gind.rio.dw.resources.GisResource;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.setup.Environment;
import jakarta.xml.ws.Endpoint;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RIOPLAYService
extends RIOGAService {
    private static Logger LOG = LoggerFactory.getLogger((String)RIOPLAYService.class.getName());
    private NotificationConsumerWebService governanceConsumer = null;
    private Endpoint findGisCallBackServer = null;

    public RIOPLAYService() throws Exception {
        this(new HashMap<String, Object>());
    }

    public RIOPLAYService(Map<String, Object> context) throws Exception {
        super(context);
    }

    public String getName() {
        return "r-ioplay";
    }

    public String getRedirection() {
        return "/rioplay";
    }

    public RIOPLAYApplicationContext createApplicationContext() throws Exception {
        return new RIOPLAYApplicationContext((DWApplicationService)this);
    }

    public void doRun(Configuration configuration, Environment environment, RestResourceManager resourcesManager) throws Exception {
        super.doRun(configuration, environment, resourcesManager);
        resourcesManager.addResource((Object)new GeoJSONResource(this.conf));
        resourcesManager.addResource((Object)new GisResource(this.conf));
        this.activatePubSubServerServlet(environment);
        try {
            this.createNotifierToReceiveEventFromGovernanceAndCampaignManager();
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.createNotifierToReceiveEventFromGisStorage();
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void createNotifierToReceiveEventFromGisStorage() throws Exception {
        this.findGisCallBackServer = StaticJettyServer.getInstance().publishJAXWSEndpoint(SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.conf.getHost(), (int)Integer.parseInt((String)this.conf.getProperties().get("notifier-for-h2gis-port")), (int)Integer.parseInt((String)this.conf.getProperties().get("proxy-port")), (String)"/FindGisCallBack"), (Object)new FindGisCallbackIOPlayImpl(WEB_SOCKET_COMMAND));
    }

    private void createNotifierToReceiveEventFromGovernanceAndCampaignManager() throws Exception {
        String sigNotifierClientAddress = SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.conf.getHost(), (int)Integer.parseInt((String)this.conf.getProperties().get("notifier-for-ie-port")), (int)Integer.parseInt((String)this.conf.getProperties().get("proxy-port")), (String)"/RIOPlayNotifierForIE");
        final RIOPLAYNotifierClient sigNotifier = new RIOPLAYNotifierClient(sigNotifierClientAddress, WEB_SOCKET_COMMAND, this.getName(), this.coreResource);
        this.governanceConsumer = new NotificationConsumerWebService();
        this.governanceConsumer.start((Map)new HashMap<String, Object>(this){
            final /* synthetic */ RIOPLAYService this$0;
            {
                this.this$0 = this$0;
                this.put("host", "0.0.0.0");
                this.put("port", this.this$0.conf.getProperties().get("notifier-for-ie-port"));
                this.put("serviceName", "RIOPlayNotifierForIE");
                this.put("notifierClient", sigNotifier);
            }
        });
        if (this.conf.getProperties().get("governance") != null) {
            if (LocalRegistry.getInstance().findWS(GovernanceWebService.class) != null) {
                GovernanceWebService governanceWebService = (GovernanceWebService)LocalRegistry.getInstance().findWS(GovernanceWebService.class);
                NotificationManagerImpl governanceNotifier = (NotificationManagerImpl)governanceWebService.getImplementation(NotificationManagerImpl.class);
                sigNotifier.subscribeOn(governanceNotifier, new QName("http://www.gind.emac.fr/EventType", "allNodeAndEventTopic"));
            } else {
                String governanceSubscribeAddress = ((String)this.conf.getProperties().get("governance")).replace("/gov", "/GovCoreSubscriber");
                sigNotifier.subscribeOn(governanceSubscribeAddress, new QName("http://www.gind.emac.fr/EventType", "allNodeAndEventTopic"));
            }
        }
        if (this.conf.getProperties().get("campaign-manager") != null) {
            if (LocalRegistry.getInstance().findWS(CampaignManagerWebService.class) != null) {
                CampaignManagerWebService campaignWebService = (CampaignManagerWebService)LocalRegistry.getInstance().findWS(CampaignManagerWebService.class);
                CampaignManagerSubscriber campaignNotifier = (CampaignManagerSubscriber)campaignWebService.getImplementation(CampaignManagerSubscriber.class);
                sigNotifier.subscribeOn((NotificationManagerImpl)campaignNotifier, new QName("http://www.gind.emac.fr/EventType", "allInterpretationEngineTopic"));
            } else {
                sigNotifier.subscribeOn(((String)this.conf.getProperties().get("campaign-manager")).replace("/TestCampaign", "/TestCampaignSubscriber"), new QName("http://www.gind.emac.fr/EventType", "allInterpretationEngineTopic"));
            }
        }
    }

    public void stop() throws Exception {
        super.stop();
        if (this.governanceConsumer != null) {
            this.governanceConsumer.stop();
        }
        if (this.findGisCallBackServer != null) {
            StaticJettyServer.getInstance().unPublishJAXWSEndpoint(this.findGisCallBackServer);
            this.findGisCallBackServer.stop();
        }
    }
}

