/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.r.iose;

import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.eventtype.GJaxbCreateSensorEvent;
import fr.emac.gind.eventtype.GJaxbStartSensorEvent;
import fr.emac.gind.eventtype.GJaxbStopSensorEvent;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.websocket.command.WebsocketCommand;
import fr.emac.gind.websocket.command.data.GJaxbGetResult;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotify;
import jakarta.jws.WebService;
import java.util.Map;
import javax.xml.namespace.QName;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@WebService(serviceName="NotifierClientService", portName="NotifierClientEndpoint", targetNamespace="http://www.gind.emac.fr/notifier", wsdlLocation="wsdl/notifier.wsdl", endpointInterface="fr.emac.gind.notifier.NotifierClient")
public class RIOSENotifierClient
extends AbstractNotifierClient {
    private static Logger LOG = LoggerFactory.getLogger((String)RIOSENotifierClient.class.getName());
    private WebsocketCommand WEB_SOCKET_COMMAND = null;

    public RIOSENotifierClient(String address, WebsocketCommand wEB_SOCKET_COMMAND) throws Exception {
        super(address);
        this.WEB_SOCKET_COMMAND = wEB_SOCKET_COMMAND;
    }

    public synchronized void notify(GJaxbNotify notify) {
        try {
            Object result = null;
            LOG.debug("[RIOSE Event] received notifcation");
            Document doc = WSNHelper.getInstance().getFirstMessageInNotification(notify);
            String json = null;
            String collaborationName = null;
            String knowledgeName = null;
            if ("createSensorEvent".equals(doc.getDocumentElement().getLocalName())) {
                LOG.debug("[RIOSE Event] received CreateSensorEvent");
                event = (GJaxbCreateSensorEvent)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbCreateSensorEvent.class);
                collaborationName = event.getCollaborationName();
                knowledgeName = event.getKnowledgeSpaceName();
                json = JSONJAXBContext.getInstance().marshallAnyElement((Object)event);
            } else if ("startSensorEvent".equals(doc.getDocumentElement().getLocalName())) {
                LOG.debug("[RIOSE Event] received StartSensorEvent");
                event = (GJaxbStartSensorEvent)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbStartSensorEvent.class);
                collaborationName = event.getCollaborationName();
                knowledgeName = event.getKnowledgeSpaceName();
                json = JSONJAXBContext.getInstance().marshallAnyElement((Object)event);
            } else if ("stopSensorEvent".equals(doc.getDocumentElement().getLocalName())) {
                LOG.debug("[RIOSE Event] received StopSensorEvent");
                event = (GJaxbStopSensorEvent)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbStopSensorEvent.class);
                collaborationName = event.getCollaborationName();
                knowledgeName = event.getKnowledgeSpaceName();
                json = JSONJAXBContext.getInstance().marshallAnyElement((Object)event);
            }
            if (json != null && collaborationName != null && knowledgeName != null) {
                Map mapInfo = WSNHelper.getInstance().getAdditionalInformationInNotification(notify);
                JSONObject jsonResult = new JSONObject();
                jsonResult.put("event", (Object)new JSONObject(json));
                jsonResult.put("createAt", (Object)((Element)mapInfo.get(new QName("http://www.gind.emac.fr", "createAt"))).getTextContent());
                jsonResult.put("sendAt", (Object)((Element)mapInfo.get(new QName("http://www.gind.emac.fr", "sendAt"))).getTextContent());
                GJaxbGetResult request = new GJaxbGetResult();
                request.setWebsocketId("/riose/" + RegExpHelper.toRegexFriendlyName((String)collaborationName).hashCode() + "/" + RegExpHelper.toRegexFriendlyName((String)knowledgeName).hashCode());
                request.setJsonResult(jsonResult.toString());
                this.WEB_SOCKET_COMMAND.getResult(request);
            }
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }
}

