/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.r.iosemit;

import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.consumer.NotificationConsumerWebService;
import fr.emac.gind.generic.application.DWApplicationService;
import fr.emac.gind.generic.application.utils.RestResourceManager;
import fr.emac.gind.r.ioga.RIOGAService;
import fr.emac.gind.r.iosemit.RIOSEMITApplicationContext;
import fr.emac.gind.r.iosemit.RIOSEMITNotifierClient;
import fr.emac.gind.rio.dw.resources.GameMasterResource;
import fr.emac.gind.rio.dw.resources.MockEndpointsManagerResource;
import fr.emac.gind.rio.dw.resources.SensorControlerResource;
import fr.emac.gind.rio.dw.resources.TimeSeriesResource;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.setup.Environment;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RIOSEMITService
extends RIOGAService {
    private static Logger LOG = LoggerFactory.getLogger((String)RIOSEMITService.class.getName());
    public static NotificationConsumerWebService RIOSEMIT_CONSUMER = null;
    public static AbstractNotifierClient RIOSEMIT_NOTIFIER = null;
    protected SensorControlerResource sensorControlerResource = null;

    public RIOSEMITService() throws Exception {
        this(new HashMap<String, Object>());
    }

    public RIOSEMITService(Map<String, Object> context) throws Exception {
        super(context);
    }

    public String getName() {
        return "r-iosemit";
    }

    public String getRedirection() {
        return "/riosemit";
    }

    public RIOSEMITApplicationContext createApplicationContext() throws Exception {
        return new RIOSEMITApplicationContext((DWApplicationService)this);
    }

    public void doRun(Configuration configuration, Environment environment, RestResourceManager resourcesManager) throws Exception {
        super.doRun(configuration, environment, resourcesManager);
        this.createNotifierToDatasetAndSensorStatusEvent();
        resourcesManager.addResource((Object)new SensorControlerResource(this.conf, this.fileResource, SENSOR_MANAGER_NOTIFIER));
        resourcesManager.addResource((Object)new MockEndpointsManagerResource(this.conf));
        resourcesManager.addResource((Object)new GameMasterResource(this.conf, this.fileResource));
        resourcesManager.addResource((Object)new TimeSeriesResource(this.conf));
        this.activatePubSubServerServlet(environment);
    }

    private void createNotifierToDatasetAndSensorStatusEvent() throws Exception {
        if (RIOSEMIT_CONSUMER == null) {
            String logNotifierClientAddress = SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.conf.getHost(), (int)Integer.parseInt((String)this.conf.getProperties().get("riosemit-notifier-for-dataset-sensors-status-port")), (int)Integer.parseInt((String)this.conf.getProperties().get("proxy-port")), (String)"/RIOSemitNotifierForSensors");
            RIOSEMIT_NOTIFIER = new RIOSEMITNotifierClient(logNotifierClientAddress, WEB_SOCKET_COMMAND);
            RIOSEMIT_CONSUMER = new NotificationConsumerWebService();
            RIOSEMIT_CONSUMER.start((Map)new HashMap<String, Object>(){
                {
                    this.put("host", "0.0.0.0");
                    this.put("port", RIOSEMITService.this.conf.getProperties().get("riosemit-notifier-for-dataset-sensors-status-port"));
                    this.put("serviceName", "RIOSemitNotifierForSensors");
                    this.put("notifierClient", RIOSEMIT_NOTIFIER);
                }
            });
            String sensorControlerSubscriberAddress = (String)this.conf.getProperties().get("sensor-controler-server") + "Subscriber";
            RIOSEMIT_NOTIFIER.subscribeOn(sensorControlerSubscriberAddress, new QName("http://www.gind.emac.fr/EventType", "allDatasetTopic"));
            RIOSEMIT_NOTIFIER.subscribeOn(sensorControlerSubscriberAddress, new QName("http://www.gind.emac.fr/EventType", "allSensorControlerTopic"));
            String sensorManagerSubscriberAddress = (String)this.conf.getProperties().get("sensor-manager-server") + "Subscriber";
            RIOSEMIT_NOTIFIER.subscribeOn(sensorManagerSubscriberAddress, new QName("http://www.gind.emac.fr/EventType", "allSensorTopic"));
        }
    }

    public void stop() throws Exception {
        if (RIOSEMIT_CONSUMER != null) {
            RIOSEMIT_CONSUMER.stop();
        }
        super.stop();
    }
}

