/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources;

import fr.emac.gind.generic.application.GindWebApplicationException;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.mock.endpoints.manager.MockEndpointManager;
import fr.emac.gind.mock.endpoints.manager.MockEndpointManagerClient;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbAddExchangeOnMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbAddExchangeOnMockEndpointResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbCreateMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbCreateMockEndpointResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbDeleteExchangeOnMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbDeleteExchangeOnMockEndpointResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbDeleteMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbDeleteMockEndpointResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbFindMockEndpointByGoodId;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbFindMockEndpointByGoodIdResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbGetMockEndpoints;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbGetMockEndpointsResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbPlayExchangeOnMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbPlayExchangeOnMockEndpointResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbRunActuatorOnMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbRunActuatorOnMockEndpointResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbStartMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbStartMockEndpointResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbStopMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbStopMockEndpointResponse;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{app}/mockEndpointManager")
@Produces(value={"application/json"})
public class MockEndpointsManagerResource {
    private static Logger LOG = LoggerFactory.getLogger(MockEndpointsManagerResource.class);
    private MockEndpointManager mockEndpointsManagerClient = null;
    private Configuration conf = null;

    public MockEndpointsManagerResource(Configuration conf) throws Exception {
        this.mockEndpointsManagerClient = MockEndpointManagerClient.createClient((String)((String)conf.getProperties().get("mock-endpoints-manager-server")));
        this.conf = conf;
    }

    @POST
    @Path(value="/createMockEndpoint")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbCreateMockEndpointResponse createMockEndpoint(@Auth DWUser user, GJaxbCreateMockEndpoint req) throws Exception {
        GJaxbCreateMockEndpointResponse response = null;
        try {
            if (req.getCollaborationName() == null) {
                req.setCollaborationName(user.getCurrentCollaborationName());
            }
            if (req.getKnowledgeSpaceName() == null) {
                req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.mockEndpointsManagerClient.createMockEndpoint(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }

    @POST
    @Path(value="/startMockEndpoint")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbStartMockEndpointResponse startMockEndpoint(@Auth DWUser user, GJaxbStartMockEndpoint req) throws Exception {
        GJaxbStartMockEndpointResponse response = null;
        try {
            if (req.getCollaborationName() == null) {
                req.setCollaborationName(user.getCurrentCollaborationName());
            }
            if (req.getKnowledgeSpaceName() == null) {
                req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.mockEndpointsManagerClient.startMockEndpoint(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        LOG.debug("Start mock endpoint at url: " + response.getMockEndpoint().getAddress());
        return response;
    }

    @POST
    @Path(value="/stopMockEndpoint")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbStopMockEndpointResponse stopMockEndpoint(@Auth DWUser user, GJaxbStopMockEndpoint req) throws Exception {
        GJaxbStopMockEndpointResponse response = null;
        try {
            if (req.getCollaborationName() == null) {
                req.setCollaborationName(user.getCurrentCollaborationName());
            }
            if (req.getKnowledgeSpaceName() == null) {
                req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.mockEndpointsManagerClient.stopMockEndpoint(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }

    @POST
    @Path(value="/deleteMockEndpoint")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbDeleteMockEndpointResponse deleteMockEndpoint(@Auth DWUser user, GJaxbDeleteMockEndpoint req) throws Exception {
        GJaxbDeleteMockEndpointResponse response = null;
        try {
            if (req.getCollaborationName() == null) {
                req.setCollaborationName(user.getCurrentCollaborationName());
            }
            if (req.getKnowledgeSpaceName() == null) {
                req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.mockEndpointsManagerClient.deleteMockEndpoint(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        LOG.debug("Delete mock endpoint with id: " + req.getId());
        return response;
    }

    @GET
    @Path(value="/getMockEndpoints")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbGetMockEndpointsResponse getMockEndpoints(@Auth DWUser user) throws Exception {
        GJaxbGetMockEndpointsResponse response = null;
        try {
            GJaxbGetMockEndpoints request = new GJaxbGetMockEndpoints();
            request.setCollaborationName(user.getCurrentCollaborationName());
            request.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            response = this.mockEndpointsManagerClient.getMockEndpoints(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }

    @POST
    @Path(value="/findMockEndpointByGoodId")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbFindMockEndpointByGoodIdResponse findMockEndpointByGoodId(@Auth DWUser user, GJaxbFindMockEndpointByGoodId req) throws Exception {
        GJaxbFindMockEndpointByGoodIdResponse response = null;
        try {
            if (req.getCollaborationName() == null) {
                req.setCollaborationName(user.getCurrentCollaborationName());
            }
            if (req.getKnowledgeSpaceName() == null) {
                req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.mockEndpointsManagerClient.findMockEndpointByGoodId(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }

    @POST
    @Path(value="/runActuatorOnMockEndpoint")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbRunActuatorOnMockEndpointResponse runActuatorOnMockEndpoint(@Auth DWUser user, GJaxbRunActuatorOnMockEndpoint req) throws Exception {
        GJaxbRunActuatorOnMockEndpointResponse response = null;
        try {
            if (req.getCollaborationName() == null) {
                req.setCollaborationName(user.getCurrentCollaborationName());
            }
            if (req.getKnowledgeSpaceName() == null) {
                req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.mockEndpointsManagerClient.runActuatorOnMockEndpoint(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }

    @POST
    @Path(value="/addExchangeOnMockEndpoint")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbAddExchangeOnMockEndpointResponse addExchangeOnMockEndpoint(@Auth DWUser user, GJaxbAddExchangeOnMockEndpoint req) throws Exception {
        GJaxbAddExchangeOnMockEndpointResponse response = null;
        try {
            if (req.getCollaborationName() == null) {
                req.setCollaborationName(user.getCurrentCollaborationName());
            }
            if (req.getKnowledgeSpaceName() == null) {
                req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.mockEndpointsManagerClient.addExchangeOnMockEndpoint(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }

    @POST
    @Path(value="/deleteExchangeOnMockEndpoint")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbDeleteExchangeOnMockEndpointResponse deleteExchangeOnMockEndpoint(@Auth DWUser user, GJaxbDeleteExchangeOnMockEndpoint req) throws Exception {
        GJaxbDeleteExchangeOnMockEndpointResponse response = null;
        try {
            if (req.getCollaborationName() == null) {
                req.setCollaborationName(user.getCurrentCollaborationName());
            }
            if (req.getKnowledgeSpaceName() == null) {
                req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.mockEndpointsManagerClient.deleteExchangeOnMockEndpoint(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }

    @POST
    @Path(value="/playExchangeOnMockEndpoint")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public GJaxbPlayExchangeOnMockEndpointResponse playExchangeOnMockEndpoint(@Auth DWUser user, GJaxbPlayExchangeOnMockEndpoint req) throws Exception {
        GJaxbPlayExchangeOnMockEndpointResponse response = null;
        try {
            if (req.getCollaborationName() == null) {
                req.setCollaborationName(user.getCurrentCollaborationName());
            }
            if (req.getKnowledgeSpaceName() == null) {
                req.setKnowledgeSpaceName(user.getCurrentKnowledgeSpaceName());
            }
            response = this.mockEndpointsManagerClient.playExchangeOnMockEndpoint(req);
        }
        catch (Exception e) {
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return response;
    }
}

