/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources;

import fr.emac.gind.campaign.manager.CampaignManagerItf;
import fr.emac.gind.campaign.manager.client.CampaignManagerClient;
import fr.emac.gind.campaign.manager.client.data.GJaxbGetCampaign;
import fr.emac.gind.campaign.manager.client.data.GJaxbGetCampaignResponse;
import fr.emac.gind.campaign.manager.client.data.GJaxbGetSolutionsFromCampaign;
import fr.emac.gind.campaign.manager.client.data.GJaxbGetSolutionsFromCampaignResponse;
import fr.emac.gind.campaign.manager.data.model.GJaxbCampaign;
import fr.emac.gind.campaign.manager.data.model.GJaxbCampaignSolution;
import fr.emac.gind.campaign.manager.data.model.GJaxbGlobalCampaign;
import fr.emac.gind.generic.application.GindWebApplicationException;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.workflow.AbstractProcessGenerator;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.poi.openxml4j.util.ZipSecureFile;

@Path(value="/{app}/r-iosepe/campaign/json")
@Consumes(value={"application/json"})
public class JsonResource {
    private CampaignManagerItf campaignClient = null;
    private List<AbstractProcessGenerator> processGenerators = new ArrayList<AbstractProcessGenerator>();

    public JsonResource(Configuration conf) throws Exception {
        if (conf != null) {
            this.campaignClient = CampaignManagerClient.createClient((String)((String)conf.getProperties().get("campaign-manager")));
        }
        this.initProcessGenerator();
    }

    public void initProcessGenerator() {
        ServiceLoader<AbstractProcessGenerator> processGeneratorLoader = ServiceLoader.load(AbstractProcessGenerator.class);
        this.processGenerators.clear();
        processGeneratorLoader.reload();
        for (AbstractProcessGenerator processGenerator : processGeneratorLoader) {
            this.processGenerators.add(processGenerator);
        }
    }

    @POST
    @Path(value="/exportCampaign")
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    public Response exportAsExcel(@Auth DWUser user, String campaignId) throws Exception {
        Response res = null;
        try {
            GJaxbGetCampaign request = new GJaxbGetCampaign();
            request.setCampaignId(campaignId);
            GJaxbGetCampaignResponse response = this.campaignClient.getCampaign(request);
            GJaxbCampaign campaign = response.getCampaign();
            GJaxbGetSolutionsFromCampaign getParam = new GJaxbGetSolutionsFromCampaign();
            getParam.setCampaignId(campaign.getCampaignId());
            GJaxbGetSolutionsFromCampaignResponse responseGet = this.campaignClient.getSolutionsFromCampaign(getParam);
            GJaxbGlobalCampaign globalCampaign = new GJaxbGlobalCampaign();
            globalCampaign.setCampaign(campaign);
            globalCampaign.getCampaignSolution().addAll(responseGet.getCampaignSolution());
            String json = JSONJAXBContext.getInstance().marshallAnyElement((Object)globalCampaign, true);
            ZipSecureFile.setMinInflateRatio((double)-1.0);
            res = Response.ok((Object)new ByteArrayInputStream(json.getBytes()), (String)"application/octet-stream").build();
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return res;
    }

    @POST
    @Path(value="/exportSolutions")
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    public Response exportAsExcel(@Auth DWUser user, List<GJaxbCampaignSolution> Solutions) throws Exception {
        Response res = null;
        try {
            GJaxbGlobalCampaign globalCampaign = new GJaxbGlobalCampaign();
            globalCampaign.getCampaignSolution().addAll(Solutions);
            String json = JSONJAXBContext.getInstance().marshallAnyElement((Object)globalCampaign, true);
            ZipSecureFile.setMinInflateRatio((double)-1.0);
            res = Response.ok((Object)new ByteArrayInputStream(json.getBytes()), (String)"application/octet-stream").build();
        }
        catch (Exception e) {
            e.printStackTrace();
            GindWebApplicationException.manageError((Exception)e, (Object)this);
        }
        return res;
    }
}

