/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.r.iota;

import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.eventcommonsdata.GJaxbProcessStatusType;
import fr.emac.gind.eventtype.GJaxbMonitoringProcessInstanceProgressionEvent;
import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.gov.core.client.util.Neo4JId;
import fr.emac.gind.gov.core.client.util.Neo4JReqConstant;
import fr.emac.gind.gov.core.service.CoreGovImpl;
import fr.emac.gind.gov.core_gov.GJaxbGetNode;
import fr.emac.gind.gov.models_gov.GJaxbConnexionModeType;
import fr.emac.gind.gov.models_gov.GJaxbOptionalParameters;
import fr.emac.gind.gov.models_gov.GJaxbPublishMode;
import fr.emac.gind.gov.models_gov.GJaxbPublishOptions;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.rio.PluginCollaborativeModel;
import fr.emac.gind.rio.dw.resources.gov.CoreResource;
import fr.emac.gind.rio.dw.resources.gov.ModelsResource;
import fr.emac.gind.rio.dw.resources.gov.SolutionResource;
import fr.emac.gind.rio.dw.resources.gov.SystemResource;
import fr.emac.gind.sharedOptions.GJaxbNotification;
import fr.emac.gind.sharedOptions.GJaxbPreAndPostTreatment;
import fr.emac.gind.websocket.command.WebsocketCommand;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotify;
import jakarta.jws.WebService;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

@WebService(serviceName="NotifierClientService", portName="NotifierClientEndpoint", targetNamespace="http://www.gind.emac.fr/notifier", wsdlLocation="wsdl/notifier.wsdl", endpointInterface="fr.emac.gind.notifier.NotifierClient")
public class RIOTAMonitoringNotifierClient
extends AbstractNotifierClient {
    private static Logger LOG = LoggerFactory.getLogger((String)RIOTAMonitoringNotifierClient.class.getName());
    private WebsocketCommand WEB_SOCKET_COMMAND = null;
    private String name = null;
    private CoreResource coreResource = null;
    private ModelsResource modelsResource = null;
    private SystemResource systemResource = null;
    private SolutionResource solutionResource = null;

    public RIOTAMonitoringNotifierClient(String address, WebsocketCommand wEB_SOCKET_COMMAND, String name, CoreResource coreResource, ModelsResource modelsResource, SystemResource systemResource, SolutionResource solutionResource) throws Exception {
        super(address);
        this.WEB_SOCKET_COMMAND = wEB_SOCKET_COMMAND;
        this.name = name;
        this.coreResource = coreResource;
        this.modelsResource = modelsResource;
        this.systemResource = systemResource;
        this.solutionResource = solutionResource;
    }

    public void notify(GJaxbNotify notify) {
        try {
            LOG.debug("[R-IOTA Event] Received notif on R-IOTA");
            System.out.println("[R-IOTA Event] Received notif on R-IOTA");
            Document doc = WSNHelper.getInstance().getFirstMessageInNotification(notify);
            GJaxbMonitoringProcessInstanceProgressionEvent me = (GJaxbMonitoringProcessInstanceProgressionEvent)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbMonitoringProcessInstanceProgressionEvent.class);
            if (me.getMonitoringInstanceProgression().getProcessStatus() == GJaxbProcessStatusType.RUNNING && me.getMonitoringInstanceProgression().getLastExchange().getExchange().getOut() != null) {
                GJaxbProperty satisfies;
                Optional<GJaxbNode.BrokenEdges.BrokenEdge> beo;
                LOG.debug("[R-IOTA Event] process running and get last exchange ended");
                System.out.println("[R-IOTA Event] process running and get last exchange ended");
                String taskId = me.getMonitoringInstanceProgression().getLastExchange().getExchange().getTaskId();
                String collaborationName = RegExpHelper.toRegexFriendlyName((String)me.getMonitoringInstanceProgression().getLastExchange().getExchange().getCollaborationName());
                String knowledgeName = RegExpHelper.toRegexFriendlyName((String)me.getMonitoringInstanceProgression().getLastExchange().getExchange().getKnowledgeSpaceName());
                DWUser fictiveUser = new DWUser(new GJaxbNode(), true, this.systemResource.getSystemClient());
                fictiveUser.setCurrentCollaborationName(collaborationName);
                fictiveUser.setCurrentKnowledgeSpaceName(knowledgeName);
                GJaxbGetNode req = new GJaxbGetNode();
                req.setId(taskId);
                GJaxbNode task = this.coreResource.getNode(fictiveUser, req).getNode();
                LOG.debug("[R-IOTA Event] task ended: " + GenericModelHelper.getName((GJaxbNode)task));
                System.out.println("[R-IOTA Event] task ended: " + GenericModelHelper.getName((GJaxbNode)task));
                GJaxbGenericModel objModel = null;
                if (task.getBrokenEdges() != null && (beo = task.getBrokenEdges().getBrokenEdge().stream().filter(be -> be.getEdge().getType().equals(new QName(PluginCollaborativeModel.COLLABORATIVE_NAMESPACE, "Created_By"))).findFirst()).isPresent() && (satisfies = GenericModelHelper.findProperty((String)"satisfies", (List)beo.get().getEdge().getProperty())) != null) {
                    List props_table = GenericModelHelper.convertJSONArrayToTable((JSONArray)new JSONArray(satisfies.getValue()));
                    for (List props : props_table) {
                        String objId = GenericModelHelper.findProperty((String)"id", (List)props).getValue();
                        GJaxbNode selectedSolution = this.solutionResource._findSelectedSolution(fictiveUser);
                        String expectedObjId = "expected_freeze##" + selectedSolution.getId() + "##" + objId + "_c__" + RegExpHelper.toRegexFriendlyName((String)collaborationName) + "_k__" + RegExpHelper.toRegexFriendlyName((String)knowledgeName);
                        String objQuery = "match (o:EXPECTED_FREEZE:" + Neo4JReqConstant.collab((String)"Objective") + " { modelNodeId: '" + expectedObjId + "' })-[r:" + Neo4JReqConstant.collab((String)"Treats") + "|" + Neo4JReqConstant.collab((String)"Prevents") + "]->(ap) return distinct o, ap, r ";
                        objModel = this.modelsResource.query(fictiveUser, objQuery, null);
                        if (objModel == null || objModel.getNode() == null || objModel.getNode().isEmpty()) continue;
                        GJaxbNode actOrPot = (GJaxbNode)GenericModelHelper.findNodesByType((QName)GenericModelHelper.collab((String)"Actuality"), (List)objModel.getNode()).get(0);
                        if (actOrPot == null) {
                            actOrPot = (GJaxbNode)GenericModelHelper.findNodesByType((QName)GenericModelHelper.collab((String)"Potentiality"), (List)objModel.getNode()).get(0);
                        }
                        String actOrPotId = actOrPot.getId();
                        String actQuery = "match (ap:EXPECTED_FREEZE { modelNodeId: '" + Neo4JId.createIdUsingCollaboration((String)actOrPotId, (String)collaborationName, (String)knowledgeName) + "' })<-[r:" + Neo4JReqConstant.collab((String)"Treats") + "|" + Neo4JReqConstant.collab((String)"Prevents") + "]-(o:" + Neo4JReqConstant.collab((String)"Objective") + ") return distinct o";
                        GJaxbGenericModel actModel = this.modelsResource.query(fictiveUser, actQuery, null);
                        List objectivesAssociatedToActOrPot = GenericModelHelper.findNodesByType((QName)GenericModelHelper.collab((String)"Objective"), (List)actModel.getNode());
                        GJaxbGenericModel modelToDelete = objModel;
                        if (objectivesAssociatedToActOrPot.size() > 1) {
                            modelToDelete.getNode().removeIf(n -> n.getId().equals(actOrPotId));
                        }
                        LOG.debug("[R-IOTA Event] unpublish start ");
                        System.out.println("[R-IOTA Event] unpublish start ");
                        if (objModel.getNode().isEmpty()) continue;
                        GJaxbOptionalParameters gJaxbOptionalParameters = new GJaxbOptionalParameters();
                        gJaxbOptionalParameters.setPublication(new GJaxbOptionalParameters.Publication());
                        gJaxbOptionalParameters.getPublication().setMode(GJaxbConnexionModeType.SYNC);
                        gJaxbOptionalParameters.getPublication().setPublishOptions(new GJaxbPublishOptions());
                        gJaxbOptionalParameters.getPublication().getPublishOptions().setPublishMode(GJaxbPublishMode.COMPLETE_TRANSACTION);
                        gJaxbOptionalParameters.getPublication().getPublishOptions().setNotification(new GJaxbNotification());
                        gJaxbOptionalParameters.getPublication().getPublishOptions().getNotification().setActivateNotification(true);
                        gJaxbOptionalParameters.getPublication().getPublishOptions().setPreAndPostTreatment(new GJaxbPreAndPostTreatment());
                        gJaxbOptionalParameters.getPublication().getPublishOptions().getPreAndPostTreatment().setActivatePreAndPostTreatment(true);
                        this.modelsResource.unpublish(collaborationName, knowledgeName, modelToDelete, gJaxbOptionalParameters, Arrays.asList(me.getMonitoringInstanceProgression().getProcessInstanceId(), CoreGovImpl.DEFAULT_INSTANCE_NODE_LABEL, selectedSolution.getId()));
                        LOG.debug("[R-IOTA Event] unpublish ended ");
                        System.out.println("[R-IOTA Event] unpublish ended ");
                    }
                }
                if (objModel == null || objModel.getNode().isEmpty()) {
                    LOG.debug("[R-IOTA Event] No objective to delete corresponding to task: " + GenericModelHelper.getName((GJaxbNode)task));
                    System.out.println("[R-IOTA Event] No objective to delete corresponding to task: " + GenericModelHelper.getName((GJaxbNode)task));
                } else {
                    Object msg = "";
                    for (GJaxbNode n2 : objModel.getNode()) {
                        msg = (String)msg + "'" + GenericModelHelper.getName((GJaxbNode)n2) + "'  ('" + n2.getType().getLocalPart() + "'), ";
                    }
                    if (((String)msg).length() > 0) {
                        msg = ((String)msg).substring(0, ((String)msg).length() - ", ".length());
                    }
                    LOG.debug("[R-IOTA Event] Nodes deleted from task '" + GenericModelHelper.getName((GJaxbNode)task) + "' : " + (String)msg);
                    System.out.println("[R-IOTA Event] Nodes deleted from task '" + GenericModelHelper.getName((GJaxbNode)task) + "' : " + (String)msg);
                }
            }
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }
}

