/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.r.iota;

import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.ws.LocalRegistry;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.consumer.NotificationConsumerWebService;
import fr.emac.gind.event.producer.NotificationManagerImpl;
import fr.emac.gind.generic.application.DWApplicationService;
import fr.emac.gind.generic.application.utils.RestResourceManager;
import fr.emac.gind.governance.GovernanceWebService;
import fr.emac.gind.monitoring.server.MonitoringWebService;
import fr.emac.gind.r.ioda.RIODAService;
import fr.emac.gind.r.iota.RIOTAApplicationContext;
import fr.emac.gind.r.iota.RIOTACoreGovNotifierClient;
import fr.emac.gind.r.iota.RIOTAIOTReflexNotifierClient;
import fr.emac.gind.r.iota.RIOTAMonitoringNotifierClient;
import fr.emac.gind.rio.dw.resources.DetectionResource;
import fr.emac.gind.rio.dw.resources.LightControlerResource;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.setup.Environment;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RIOTAService
extends RIODAService {
    private static Logger LOG = LoggerFactory.getLogger((String)RIOTAService.class.getName());
    private NotificationConsumerWebService monitoringConsumer = null;
    private NotificationConsumerWebService governanceConsumer = null;
    private LightControlerResource lightControlerResource = null;
    public static NotificationConsumerWebService IOT_REFLEX_CONSUMER = null;
    public static AbstractNotifierClient IOT_REFLEX_NOTIFIER = null;

    public RIOTAService() throws Exception {
        this(new HashMap<String, Object>());
    }

    public RIOTAService(Map<String, Object> context) throws Exception {
        super(context);
    }

    public String getName() {
        return "r-iota";
    }

    public String getRedirection() {
        return "/riota";
    }

    public RIOTAApplicationContext createApplicationContext() throws Exception {
        return new RIOTAApplicationContext((DWApplicationService)this);
    }

    public void doRun(Configuration configuration, Environment environment, RestResourceManager resourcesManager) throws Exception {
        super.doRun(configuration, environment, resourcesManager);
        this.lightControlerResource = new LightControlerResource(this.conf);
        resourcesManager.addResource((Object)new DetectionResource(this.conf, (RIOTAApplicationContext)this.getApplicationContext(), this.projectResource, this.fileResource));
        resourcesManager.addResource((Object)this.lightControlerResource);
        this.createNotifierForMonitoringEvent();
        this.createNotifierForCoreGovEvent();
        this.createNotifierForIOTReflexEvent();
    }

    public LightControlerResource getLightControlerResource() {
        return this.lightControlerResource;
    }

    private void createNotifierForIOTReflexEvent() throws Exception {
        if (IOT_REFLEX_CONSUMER == null) {
            String notifierClientAddress = SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.conf.getHost(), (int)Integer.parseInt((String)this.conf.getProperties().get("riota-iot-reflex-notifier-port")), (int)Integer.parseInt((String)this.conf.getProperties().get("proxy-port")), (String)"/RIOTANotifierForIOTReflex");
            IOT_REFLEX_NOTIFIER = new RIOTAIOTReflexNotifierClient(notifierClientAddress, WEB_SOCKET_COMMAND, this.getName(), this.coreResource, this.modelsResource);
            IOT_REFLEX_CONSUMER = new NotificationConsumerWebService();
            IOT_REFLEX_CONSUMER.start((Map)new HashMap<String, Object>(){
                {
                    this.put("host", "0.0.0.0");
                    this.put("port", RIOTAService.this.conf.getProperties().get("riota-iot-reflex-notifier-port"));
                    this.put("serviceName", "RIOTANotifierForIOTReflex");
                    this.put("notifierClient", IOT_REFLEX_NOTIFIER);
                }
            });
            String brokerSubscribeAddress = (String)this.conf.getProperties().get("event-broker");
            IOT_REFLEX_NOTIFIER.subscribeOn(brokerSubscribeAddress, new QName("http://www.gind.emac.fr/EventType", "reflexTopic"));
        }
    }

    private void createNotifierForMonitoringEvent() throws Exception {
        String notifierClientAddress = SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.conf.getHost(), (int)Integer.parseInt((String)this.conf.getProperties().get("riota-monitoring-notifier-port")), (int)Integer.parseInt((String)this.conf.getProperties().get("proxy-port")), (String)"/RIOTANotifierForMonitoring");
        final RIOTAMonitoringNotifierClient notifier = new RIOTAMonitoringNotifierClient(notifierClientAddress, WEB_SOCKET_COMMAND, this.getName(), this.coreResource, this.modelsResource, this.systemResource, this.solutionResource);
        this.monitoringConsumer = new NotificationConsumerWebService();
        this.monitoringConsumer.start((Map)new HashMap<String, Object>(this){
            final /* synthetic */ RIOTAService this$0;
            {
                this.this$0 = this$0;
                this.put("host", this.this$0.conf.getProperties().get("host"));
                this.put("port", this.this$0.conf.getProperties().get("riota-monitoring-notifier-port"));
                this.put("serviceName", "RIOTANotifierForMonitoring");
                this.put("notifierClient", notifier);
            }
        });
        if (LocalRegistry.getInstance().findWS(MonitoringWebService.class) != null) {
            MonitoringWebService monitoringWebService = (MonitoringWebService)LocalRegistry.getInstance().findWS(MonitoringWebService.class);
            NotificationManagerImpl monitoringProducer = (NotificationManagerImpl)monitoringWebService.getImplementation(NotificationManagerImpl.class);
            notifier.subscribeOn(monitoringProducer, new QName("http://www.gind.emac.fr/EventType", "monitoringProcessInstanceProgressionTopic"));
        } else {
            String monitoringSubscribeAddress = ((String)this.conf.getProperties().get("monitoring-server")).replace("ProcessMonitoring", "ProcessMonitoringSubscriber");
            notifier.subscribeOn(monitoringSubscribeAddress, new QName("http://www.gind.emac.fr/EventType", "monitoringProcessInstanceProgressionTopic"));
        }
    }

    private void createNotifierForCoreGovEvent() throws Exception {
        String notifierClientAddress = SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.conf.getHost(), (int)Integer.parseInt((String)this.conf.getProperties().get("riota-core-gov-notifier-port")), (int)Integer.parseInt((String)this.conf.getProperties().get("proxy-port")), (String)"/RIOTaNotifierForGovernance");
        final RIOTACoreGovNotifierClient notifier = new RIOTACoreGovNotifierClient(notifierClientAddress, WEB_SOCKET_COMMAND, this.getName(), this.coreResource, this.modelsResource);
        this.governanceConsumer = new NotificationConsumerWebService();
        this.governanceConsumer.start((Map)new HashMap<String, Object>(this){
            final /* synthetic */ RIOTAService this$0;
            {
                this.this$0 = this$0;
                this.put("host", this.this$0.conf.getProperties().get("host"));
                this.put("port", this.this$0.conf.getProperties().get("riota-core-gov-notifier-port"));
                this.put("serviceName", "RIOTaNotifierForGovernance");
                this.put("notifierClient", notifier);
            }
        });
        if (LocalRegistry.getInstance().findWS(GovernanceWebService.class) != null) {
            GovernanceWebService governanceWebService = (GovernanceWebService)LocalRegistry.getInstance().findWS(GovernanceWebService.class);
            NotificationManagerImpl governanceNotifier = (NotificationManagerImpl)governanceWebService.getImplementation(NotificationManagerImpl.class);
            notifier.subscribeOn(governanceNotifier, new QName("http://www.gind.emac.fr/EventType", "allNodeAndEventTopic"));
        } else {
            String governanceSubscribeAddress = ((String)this.conf.getProperties().get("governance")).replace("/gov", "/GovCoreSubscriber");
            notifier.subscribeOn(governanceSubscribeAddress, new QName("http://www.gind.emac.fr/EventType", "allNodeAndEventTopic"));
        }
    }

    public void stop() throws Exception {
        super.stop();
        if (this.governanceConsumer != null) {
            this.governanceConsumer.stop();
        }
        if (this.monitoringConsumer != null) {
            this.monitoringConsumer.stop();
        }
    }
}

