/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.rio.dw.resources;

import fr.emac.gind.generic.application.users.DWUser;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.rio.dw.resources.bo.LightInput;
import io.dropwizard.auth.Auth;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{app}/r-iota/lightcontroler")
@Produces(value={"application/json"})
public class LightControlerResource {
    private static Logger LOG = LoggerFactory.getLogger((String)LightControlerResource.class.getName());
    private String philips_hue_ip_brigde = null;
    private String philips_hue_light_id = null;
    private static String PHILIPS_HUE_APPLICATION_KEY = null;
    private boolean lightErrorDetected = false;

    public LightControlerResource(Configuration conf) throws Exception {
        if (conf.getProperties().get("philips_hue_ip_brigde") != null) {
            this.philips_hue_ip_brigde = (String)conf.getProperties().get("philips_hue_ip_brigde");
        }
        if (conf.getProperties().get("philips_hue_light_id") != null) {
            this.philips_hue_light_id = (String)conf.getProperties().get("philips_hue_light_id");
        }
        if (System.getenv("PHILIPS_HUE_APPLICATION_KEY") != null) {
            PHILIPS_HUE_APPLICATION_KEY = System.getenv().get("PHILIPS_HUE_APPLICATION_KEY");
        }
    }

    public boolean isActivated() {
        return this.philips_hue_ip_brigde != null && PHILIPS_HUE_APPLICATION_KEY != null && this.philips_hue_light_id != null;
    }

    @PUT
    @Path(value="/controlLight")
    @Consumes(value={"application/json"})
    public String controlLight(@Auth DWUser user, LightInput parameters) throws Exception {
        JSONObject res;
        block18: {
            res = new JSONObject();
            if (!this.lightErrorDetected) {
                try {
                    if (this.isActivated()) {
                        String address = "https://<bridge ip address>/clip/v2/resource/light/<id>";
                        address = address.replace("<bridge ip address>", this.philips_hue_ip_brigde);
                        address = address.replace("<id>", this.philips_hue_light_id);
                        JSONObject payload = new JSONObject();
                        JSONObject on = new JSONObject();
                        on.put("on", true);
                        payload.put("on", (Object)on);
                        JSONObject dimming = new JSONObject();
                        dimming.put("brightness", parameters.getBrightness());
                        payload.put("dimming", (Object)dimming);
                        JSONObject color = new JSONObject();
                        JSONObject xy = new JSONObject();
                        xy.put("x", parameters.getColorX());
                        xy.put("y", parameters.getColorY());
                        color.put("xy", (Object)xy);
                        payload.put("color", (Object)color);
                        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(this){

                            @Override
                            public void checkClientTrusted(X509Certificate[] chain, String authType) {
                            }

                            @Override
                            public void checkServerTrusted(X509Certificate[] chain, String authType) {
                            }

                            @Override
                            public X509Certificate[] getAcceptedIssuers() {
                                return null;
                            }
                        }};
                        SSLContext sslContext = SSLContext.getInstance("SSL");
                        sslContext.init(null, trustAllCerts, new SecureRandom());
                        HttpsURLConnection urlConnection = (HttpsURLConnection)new URL(address).openConnection();
                        urlConnection.setSSLSocketFactory(sslContext.getSocketFactory());
                        urlConnection.setRequestProperty("hue-application-key", PHILIPS_HUE_APPLICATION_KEY.trim());
                        urlConnection.setDoOutput(true);
                        urlConnection.setRequestMethod("PUT");
                        urlConnection.setUseCaches(false);
                        urlConnection.setHostnameVerifier(new HostnameVerifier(this){

                            @Override
                            public boolean verify(String hostname, SSLSession sslSession) {
                                return true;
                            }
                        });
                        try (OutputStream os = urlConnection.getOutputStream();){
                            byte[] input = payload.toString().getBytes("utf-8");
                            os.write(input, 0, input.length);
                        }
                        LOG.debug("Change light:  (color: [x:" + parameters.getColorX() + ", y:" + parameters.getColorY() + "]");
                        System.out.println("Change light:  (color: [x:" + parameters.getColorX() + ", y:" + parameters.getColorY() + "]");
                        urlConnection.connect();
                        int responseCode = urlConnection.getResponseCode();
                        if (responseCode == 200) {
                            try (BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "utf-8"));){
                                StringBuffer stringBuffer = new StringBuffer();
                                String line = "";
                                while ((line = reader.readLine()) != null) {
                                    stringBuffer.append(line);
                                }
                                String content = stringBuffer.toString();
                                System.out.println(content);
                                break block18;
                            }
                        }
                        LOG.warn("HTTP Error: " + responseCode + " (color: [x:" + parameters.getColorX() + ", y:" + parameters.getColorY() + "]");
                        break block18;
                    }
                    LOG.warn("Light controler (Philips hue not correctly configured) !!!");
                }
                catch (Throwable e) {
                    LOG.error("Light controler (Philips hue not correctly configured) !!!", e);
                    res.put("error", (Object)("Light controler (Philips hue not correctly configured) !!!: " + e.getMessage()));
                    this.lightErrorDetected = true;
                }
            }
        }
        return res.toString();
    }
}

