/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.generic.application.websocket.pubsub;

import fr.emac.gind.event.pubsub.GJaxbMessage;
import fr.emac.gind.event.pubsub.GJaxbMessageDirection;
import fr.emac.gind.generic.application.websocket.pubsub.EndpointHandler;
import fr.emac.gind.generic.application.websocket.pubsub.MessageLocker;
import fr.emac.gind.generic.application.websocket.pubsub.TopicManager;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import org.eclipse.jetty.websocket.api.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubSubEndpoint
implements Session.Listener.AutoDemanding {
    private Session session_;
    private static Logger LOG = LoggerFactory.getLogger((String)PubSubEndpoint.class.getName());

    public Session getSession() {
        return this.session_;
    }

    public void onWebSocketOpen(Session session) {
        this.session_ = session;
        String topic = session.getUpgradeRequest().getRequestURI().getPath().replace("/ws/pubsub/", "");
        if (topic.startsWith("rioda/reload_")) {
            System.out.println("break");
        }
        EndpointHandler handler = EndpointHandler.getInstance();
        TopicManager.getInstance().addTopic(this);
        handler.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWebSocketText(String message) {
        EndpointHandler handler = EndpointHandler.getInstance();
        try {
            GJaxbMessage msg = (GJaxbMessage)JSONJAXBContext.getInstance().unmarshall("{ \"message\" : " + message + "}", GJaxbMessage.class);
            if (msg.getMessageDirection() == GJaxbMessageDirection.OUT) {
                LOG.info("msg.getId = " + msg.getId());
                MessageLocker locker = TopicManager.getInstance().getMessageLockersMap().get(msg.getId());
                assert (locker != null) : "locker cannot be null: " + String.valueOf(msg);
                MessageLocker messageLocker = locker;
                synchronized (messageLocker) {
                    locker.setMessage(msg);
                    locker.notify();
                }
            }
            handler.broadcastMessage(message);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void onWebSocketError(Throwable cause) {
        EndpointHandler handler = EndpointHandler.getInstance();
        handler.removeByInstance(this);
        TopicManager.getInstance().removeEndpoint(this);
        cause.printStackTrace(System.err);
    }

    public void onWebSocketClose(int statusCode, String reason) {
        EndpointHandler handler = EndpointHandler.getInstance();
        handler.removeByInstance(this);
        TopicManager.getInstance().removeEndpoint(this);
    }
}

