/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.generic.application.websocket.pubsub;

import fr.emac.gind.generic.application.websocket.pubsub.MessageLocker;
import fr.emac.gind.generic.application.websocket.pubsub.PubSubEndpoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicManager {
    private static Logger LOG = LoggerFactory.getLogger((String)TopicManager.class.getName());
    private static TopicManager INSTANCE;
    private static Map<String, List<PubSubEndpoint>> topicsMap;
    private Map<String, MessageLocker> messageLockersMap = Collections.synchronizedMap(new HashMap());

    private TopicManager() {
    }

    public static TopicManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TopicManager();
        }
        return INSTANCE;
    }

    public void addTopic(PubSubEndpoint endpoint) {
        String topic = endpoint.getSession().getUpgradeRequest().getRequestURI().getPath().replace("/ws/pubsub/", "");
        if (topicsMap.get(topic) == null) {
            topicsMap.put(topic, Collections.synchronizedList(new ArrayList()));
        }
        topicsMap.get(topic).add(endpoint);
    }

    public List<PubSubEndpoint> findTopic(String topicName) {
        if (topicsMap.get(topicName) != null) {
            return Collections.unmodifiableList(topicsMap.get(topicName));
        }
        if (topicName != null && topicName.startsWith("/") && topicsMap.get(topicName = topicName.replaceFirst("/", "")) != null) {
            return Collections.unmodifiableList(topicsMap.get(topicName));
        }
        return null;
    }

    public Map<String, List<PubSubEndpoint>> getTopicsMap() {
        return topicsMap;
    }

    public Map<String, MessageLocker> getMessageLockersMap() {
        return this.messageLockersMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastMessage(String topic, String message) {
        ArrayList<PubSubEndpoint> endpoints = new ArrayList<PubSubEndpoint>(this.findTopic(topic));
        ArrayList endpointsToRemote = new ArrayList();
        if (endpoints != null && !endpoints.isEmpty()) {
            Iterator it;
            Iterator iterator = it = endpoints.iterator();
            synchronized (iterator) {
                while (it.hasNext()) {
                    Session s;
                    PubSubEndpoint p = (PubSubEndpoint)it.next();
                    if (p == null || (s = p.getSession()) == null || !s.isOpen()) continue;
                    s.sendText(message, Callback.from(() -> {}, x -> {
                        x.printStackTrace();
                        endpointsToRemote.add(p);
                    }));
                }
            }
        }
    }

    public void removeEndpoint(PubSubEndpoint endpoint) {
        LOG.debug("Remove endpoint " + String.valueOf(endpoint));
        for (Map.Entry<String, List<PubSubEndpoint>> entry : topicsMap.entrySet()) {
            if (!entry.getValue().contains(endpoint)) continue;
            LOG.debug("... removing endpoint in topic " + entry.getKey());
            entry.getValue().remove(endpoint);
            break;
        }
    }

    static {
        topicsMap = new HashMap<String, List<PubSubEndpoint>>();
    }
}

